/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.impl.AbstractPKCS11TokenKeyStoreProtectionManager;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.WrappedOnDemandX509CertificateEx;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.TestUtils;

public class SMIMECryptographerImpl_wrappableHSMDirectTest {
    protected String oldSensitiveProvider;

    @Before
    public void setUp() {
        this.oldSensitiveProvider = CryptoExtensions.getJCESensitiveProviderName();
    }

    @After
    public void done() {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_SENTITIVE_PROVIDER", this.oldSensitiveProvider));
    }

    protected boolean shouldRunTest() {
        try {
            String pkcs11ProvName = TestUtils.setupLunaToken();
            if (StringUtils.isEmpty((CharSequence)pkcs11ProvName)) {
                System.out.println("No HSM detected.  Skipping test.");
                return false;
            }
            OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_SENTITIVE_PROVIDER", pkcs11ProvName));
        }
        catch (Exception e) {
            System.out.println("No HSM detected.  Skipping test.");
            return false;
        }
        return true;
    }

    protected AbstractPKCS11TokenKeyStoreProtectionManager getKeyStoreMgr() throws Exception {
        AbstractPKCS11TokenKeyStoreProtectionManager mgr = TestUtils.getLunaKeyStoreMgr();
        return mgr;
    }

    @Test
    public void testEncryptSingDecryptWithWrappedKey() throws Exception {
        if (this.shouldRunTest()) {
            KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
            FileInputStream inStream = FileUtils.openInputStream((File)new File("./src/test/resources/certs/hsmtest.p12"));
            localKeyStore.load(inStream, "".toCharArray());
            Enumeration<String> aliases = localKeyStore.aliases();
            String alias = aliases.nextElement();
            X509Certificate theCert = (X509Certificate)localKeyStore.getCertificate(alias);
            PrivateKey thePrivKey = (PrivateKey)localKeyStore.getKey(alias, "".toCharArray());
            AbstractPKCS11TokenKeyStoreProtectionManager keyMgr = this.getKeyStoreMgr();
            byte[] wrappedKey = keyMgr.wrapWithSecretKey((SecretKey)keyMgr.getPrivateKeyProtectionKey(), (Key)thePrivKey);
            X509CertificateEx wrappedCert = WrappedOnDemandX509CertificateEx.fromX509Certificate((KeyStoreProtectionManager)keyMgr, (X509Certificate)theCert, (byte[])wrappedKey);
            CertificateResolver resolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
            Mockito.when((Object)resolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(Arrays.asList(wrappedCert));
            TrustAnchorResolver trustResolver = (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class);
            Mockito.when((Object)trustResolver.getIncomingAnchors()).thenReturn((Object)resolver);
            Mockito.when((Object)trustResolver.getOutgoingAnchors()).thenReturn((Object)resolver);
            DefaultNHINDAgent agent = new DefaultNHINDAgent("messaging.cerner.com", resolver, resolver, trustResolver);
            MimeMessage msg = new MimeMessage((Session)null);
            msg.setFrom((Address)new InternetAddress("hsmtest@messaging.cerner.com"));
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress("hsmtest@messaging.cerner.com"));
            msg.setText("Hello");
            msg.saveChanges();
            OutgoingMessage encrytpedMsg = agent.processOutgoing(new OutgoingMessage(new Message(msg)));
            agent.processIncoming((MimeMessage)encrytpedMsg.getMessage());
        }
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

