/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.notifications.NotificationHelper;

@RunWith(value=MockitoJUnitRunner.class)
public class NotificationHelperTest {
    @Mock
    private Message mockMessage;
    private static final String DISPOSITION_NOTIFICATION_TO = "a@test.com";
    private static final String FROM = "b@test.com";

    @Test
    public void testNoDestination() throws Exception {
        String destination = NotificationHelper.getNotificationDestination((Message)this.mockMessage);
        Assert.assertEquals((Object)"", (Object)destination);
    }

    @Test
    public void testDispositionNotification() throws Exception {
        Mockito.when((Object)this.mockMessage.getHeader("Disposition-Notification-To")).thenReturn((Object)new String[]{DISPOSITION_NOTIFICATION_TO});
        String destination = NotificationHelper.getNotificationDestination((Message)this.mockMessage);
        Assert.assertEquals((Object)DISPOSITION_NOTIFICATION_TO, (Object)destination);
    }

    @Test
    public void testDispositionNotificationTo() throws Exception {
        Mockito.when((Object)this.mockMessage.getHeader("Disposition-Notification-To")).thenReturn((Object)new String[]{DISPOSITION_NOTIFICATION_TO});
        String destination = NotificationHelper.getNotificationDestination((Message)this.mockMessage);
        Assert.assertEquals((Object)DISPOSITION_NOTIFICATION_TO, (Object)destination);
    }

    @Test
    public void testMultipleDispositionNotificationTo() throws Exception {
        String anotherAddress = "anotheraddress@test.com";
        Mockito.when((Object)this.mockMessage.getHeader("Disposition-Notification-To")).thenReturn((Object)new String[]{DISPOSITION_NOTIFICATION_TO, anotherAddress});
        String destination = NotificationHelper.getNotificationDestination((Message)this.mockMessage);
        Assert.assertEquals((Object)("a@test.com," + anotherAddress), (Object)destination);
    }

    @Test
    public void testNullDispositionNotificationTo_FromAsFallback() throws Exception {
        Mockito.when((Object)this.mockMessage.getHeader("Disposition-Notification-To")).thenReturn(null);
        Mockito.when((Object)this.mockMessage.getHeader("from")).thenReturn((Object)new String[]{FROM});
        String destination = NotificationHelper.getNotificationDestination((Message)this.mockMessage);
        Assert.assertEquals((Object)FROM, (Object)destination);
    }

    @Test
    public void testEmptyDispositionNotificationTo_FromAsFallback() throws Exception {
        Mockito.when((Object)this.mockMessage.getHeader("Disposition-Notification-To")).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.mockMessage.getHeader("from")).thenReturn((Object)new String[]{FROM});
        String destination = NotificationHelper.getNotificationDestination((Message)this.mockMessage);
        Assert.assertEquals((Object)FROM, (Object)destination);
    }

    @Test
    public void testDispositionNotificationToDuplicatesAreRemoved() throws Exception {
        Mockito.when((Object)this.mockMessage.getHeader("Disposition-Notification-To")).thenReturn((Object)new String[]{DISPOSITION_NOTIFICATION_TO, DISPOSITION_NOTIFICATION_TO.toUpperCase()});
        String destination = NotificationHelper.getNotificationDestination((Message)this.mockMessage);
        Assert.assertEquals((Object)DISPOSITION_NOTIFICATION_TO, (Object)destination);
    }

    @Test
    public void testFromDuplicatesAreRemoved() throws Exception {
        Mockito.when((Object)this.mockMessage.getHeader("Disposition-Notification-To")).thenReturn(null);
        Mockito.when((Object)this.mockMessage.getHeader("from")).thenReturn((Object)new String[]{FROM, FROM.toUpperCase()});
        String destination = NotificationHelper.getNotificationDestination((Message)this.mockMessage);
        Assert.assertEquals((Object)FROM, (Object)destination);
    }
}

