/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.stagent.cert.impl.LdapCertUtil;
import org.nhindirect.stagent.cert.impl.util.Lookup;
import org.nhindirect.stagent.cert.impl.util.LookupFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SRVRecord;

public class LdapPublicCertUtilImpl
implements LdapCertUtil {
    private static final Log LOGGER = LogFactory.getLog(LdapPublicCertUtilImpl.class);
    private static final String DEFAULT_LDAP_TIMEOUT = "5000";
    private static final String DEFAULT_LDAP_CONNECT_TIMEOUT = "10000";
    private static final String LDAP_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private static final String LDAP_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String LDAP_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_SRV_PREFIX = "_ldap._tcp.";
    private static final String CERT_ATTRIBUTE_BINARY = "userCertificate;binary";
    private static final String CERT_ATTRIBUTE = "userCertificate";
    private static final String EMAIL_ATTRIBUTE = "mail";
    private static final String BASE_DN_ATTRIBUTE = "namingContexts";
    private List<String> servers = new ArrayList<String>();

    public LdapPublicCertUtilImpl() {
        String[] configedServers = ResolverConfig.getCurrentConfig().servers();
        if (configedServers != null) {
            this.servers.addAll(Arrays.asList(configedServers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<X509Certificate> ldapSearch(String subjectName) {
        ArrayList<X509Certificate> retVal;
        block15: {
            retVal = new ArrayList<X509Certificate>();
            int index = subjectName.indexOf("@");
            String domainName = index > -1 ? subjectName.substring(index + 1) : subjectName;
            String lookupName = LDAP_SRV_PREFIX + domainName;
            InitialDirContext ctx = null;
            try {
                List<String> dNs;
                ctx = this.getDirContext(lookupName);
                if (ctx == null || (dNs = this.getBaseNamingContexts(ctx)).isEmpty()) break block15;
                for (String dn : dNs) {
                    NamingEnumeration<SearchResult> searchResult = ctx.search(dn, "mail=" + subjectName, this.getDefaultSearchControls());
                    if (searchResult == null || !searchResult.hasMore()) {
                        try {
                            searchResult = ctx.search(dn, "(&(mail=" + subjectName + ")(|(userCertificate;binary=*)(userCertificate=*)))", this.getDefaultSearchControls());
                        }
                        catch (Exception e) {
                            LOGGER.warn((Object)("Exception when looking up LDAP certificates using alternative search filter: " + e.getMessage()));
                        }
                    }
                    while (searchResult != null && searchResult.hasMore()) {
                        Attributes certAttributes;
                        SearchResult certEntry = (SearchResult)searchResult.nextElement();
                        if (certEntry == null || (certAttributes = certEntry.getAttributes()) == null) continue;
                        Attribute certAttribute = certAttributes.get(CERT_ATTRIBUTE_BINARY);
                        if (certAttribute == null) {
                            certAttribute = certAttributes.get(CERT_ATTRIBUTE);
                        }
                        if (certAttribute == null) continue;
                        NamingEnumeration<?> allValues = certAttribute.getAll();
                        while (allValues.hasMoreElements()) {
                            byte[] rawCert = null;
                            Object obj = allValues.nextElement();
                            rawCert = (byte[])obj;
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(rawCert);
                            try {
                                X509Certificate addCert = (X509Certificate)cf.generateCertificate(inputStream);
                                retVal.add(addCert);
                            }
                            finally {
                                IOUtils.closeQuietly((InputStream)inputStream);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Failure to lookup certificate through LDAP resolver.  Returning default value of null.", (Throwable)e);
                Collection<X509Certificate> collection = null;
                return collection;
            }
            finally {
                this.closeDirContext(ctx);
            }
        }
        return retVal;
    }

    protected InitialDirContext getDirContext(String lookupName) throws Exception {
        InitialDirContext ctx = null;
        Lookup lu = LookupFactory.getFactory().getInstance(new Name(lookupName), 33);
        lu.setResolver((Resolver)this.createExResolver(this.servers.toArray(new String[this.servers.size()]), 2, 3));
        Record[] retRecords = lu.run();
        if (retRecords != null && retRecords.length > 0) {
            String ldapURL = this.createLDAPUrl(retRecords);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", LDAP_FACTORY);
            env.put("java.naming.provider.url", ldapURL);
            env.put("java.naming.security.authentication", "none");
            env.put(LDAP_TIMEOUT, DEFAULT_LDAP_TIMEOUT);
            env.put(LDAP_CONNECT_TIMEOUT, DEFAULT_LDAP_CONNECT_TIMEOUT);
            env.put("java.naming.ldap.attributes.binary", "userCertificate, usercertificate");
            ctx = new InitialDirContext(env);
        }
        return ctx;
    }

    protected String createLDAPUrl(Record[] retRecords) {
        StringBuilder builder = new StringBuilder();
        Arrays.sort(retRecords, new SRVRecordComparitor());
        for (Record rec : retRecords) {
            String target;
            SRVRecord srvRec = (SRVRecord)rec;
            if (builder.length() > 0) {
                builder.append(" ");
            }
            target = (target = srvRec.getTarget().toString()).endsWith(".") ? target.substring(0, target.length() - 1) : target;
            String url = "ldap://" + target + ":" + srvRec.getPort();
            builder.append(url);
        }
        return builder.toString();
    }

    protected ExtendedResolver createExResolver(String[] servers, int retries, int timeout) {
        ExtendedResolver retVal = null;
        try {
            retVal = new ExtendedResolver(servers);
            retVal.setRetries(retries);
            retVal.setTimeout(timeout);
            retVal.setTCP(false);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return retVal;
    }

    protected List<String> getBaseNamingContexts(InitialDirContext ctx) {
        ArrayList<String> dNs = new ArrayList<String>();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setReturningObjFlag(true);
            ctls.setSearchScope(0);
            ctls.setReturningAttributes(new String[]{BASE_DN_ATTRIBUTE});
            NamingEnumeration<SearchResult> objResults = ctx.search("", "objectclass=*", ctls);
            while (objResults != null && objResults.hasMore()) {
                SearchResult objEntry = (SearchResult)objResults.nextElement();
                Attributes objAttributes = objEntry.getAttributes();
                if (objAttributes == null) continue;
                Attribute objAttribute = objAttributes.get(BASE_DN_ATTRIBUTE);
                NamingEnumeration<?> allValues = objAttribute.getAll();
                while (allValues.hasMoreElements()) {
                    dNs.add((String)allValues.nextElement());
                }
            }
            if (dNs.isEmpty()) {
                LOGGER.warn((Object)"No base DNs could be located for LDAP context");
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"ERROR looking up base DNs for LDAP context", (Throwable)e);
        }
        return dNs;
    }

    protected SearchControls getDefaultSearchControls() {
        SearchControls ctls = new SearchControls();
        ctls.setReturningObjFlag(true);
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(new String[]{CERT_ATTRIBUTE, CERT_ATTRIBUTE_BINARY});
        return ctls;
    }

    protected void closeDirContext(DirContext dirContext) {
        if (dirContext != null) {
            try {
                dirContext.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    protected static class SRVRecordComparitor
    implements Comparator<Record> {
        protected SRVRecordComparitor() {
        }

        @Override
        public int compare(Record rec1, Record rec2) {
            if (((SRVRecord)rec1).getPriority() == ((SRVRecord)rec2).getPriority()) {
                if (((SRVRecord)rec1).getWeight() < ((SRVRecord)rec2).getWeight()) {
                    return 1;
                }
                return ((SRVRecord)rec1).getWeight() > ((SRVRecord)rec2).getWeight() ? -1 : 0;
            }
            return ((SRVRecord)rec1).getPriority() < ((SRVRecord)rec2).getPriority() ? -1 : 1;
        }
    }
}

