/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools;

import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.mail.internet.InternetAddress;
import org.apache.commons.io.FileUtils;
import org.nhindirect.stagent.cert.impl.LDAPCertificateStore;
import org.nhindirect.stagent.cert.impl.LdapPublicCertUtilImpl;

public class LDAPCertDumper {
    public static void main(String[] args) {
        if (args.length == 0) {
            LDAPCertDumper.printUsage();
            System.exit(-1);
        }
        String emailAddress = "";
        String outFile = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                System.err.println("Error: Unexpected argument [" + arg + "]\n");
                LDAPCertDumper.printUsage();
                System.exit(-1);
                continue;
            }
            if (arg.equalsIgnoreCase("-add")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing email address");
                    System.exit(-1);
                }
                emailAddress = args[++i];
                continue;
            }
            if (arg.equals("-out")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing output file.");
                    System.exit(-1);
                }
                outFile = args[++i];
                continue;
            }
            if (arg.equals("-help")) {
                LDAPCertDumper.printUsage();
                System.exit(-1);
                continue;
            }
            System.err.println("Error: Unknown argument " + arg + "\n");
            LDAPCertDumper.printUsage();
            System.exit(-1);
        }
        if (emailAddress == null || emailAddress.isEmpty()) {
            System.err.println("You must provide an email address.");
            LDAPCertDumper.printUsage();
        } else {
            LDAPCertificateStore ldapStore = new LDAPCertificateStore(new LdapPublicCertUtilImpl(), null, null);
            try {
                Collection<X509Certificate> certs = ldapStore.getCertificates(new InternetAddress(emailAddress));
                if (certs == null || certs.size() == 0) {
                    System.out.println("No certs found");
                } else {
                    int idx = 1;
                    for (X509Certificate cert : certs) {
                        String certFileHold;
                        String certFileName = "";
                        String string = certFileHold = outFile == null || outFile.isEmpty() ? emailAddress + ".der" : outFile;
                        if (certs.size() > 1) {
                            int index = certFileHold.lastIndexOf(".");
                            if (index < 0) {
                                certFileHold = certFileHold + "(" + idx + ")";
                            } else {
                                certFileName = certFileHold.substring(0, index - 1) + "(" + idx + ")" + certFileHold.substring(index);
                            }
                        } else {
                            certFileName = certFileHold;
                        }
                        File certFile = new File(certFileName);
                        if (certFile.exists()) {
                            certFile.delete();
                        }
                        System.out.println("Writing cert file: " + certFile.getAbsolutePath());
                        FileUtils.writeByteArrayToFile((File)certFile, (byte[])cert.getEncoded());
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    private static void printUsage() {
        StringBuffer use = new StringBuffer();
        use.append("Usage:\n");
        use.append("java LDAPCertDumper (options)...\n\n");
        use.append("options:\n");
        use.append("-add address\t\tEmail address of org/domain to retrieve certs for.\n");
        use.append("\n");
        use.append("-out  Out File\t\tOptional output file name for the cert.\n");
        use.append("\t\t\tDefault: <email address>(<cert num>).der\n\n");
        System.err.println(use);
    }
}

