/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.mail.smime.CMSProcessableBodyPart;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.policy.PolicyProcessException;

public class MessageSigInspector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            System.exit(-1);
        }
        String messgefile = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                System.err.println("Error: Unexpected argument [" + arg + "]\n");
                System.exit(-1);
                continue;
            }
            if (arg.equalsIgnoreCase("-msgFile")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing message file");
                    System.exit(-1);
                }
                messgefile = args[++i];
                continue;
            }
            if (arg.equals("-help")) {
                System.exit(-1);
                continue;
            }
            System.err.println("Error: Unknown argument " + arg + "\n");
            System.exit(-1);
        }
        if (messgefile == null) {
            System.err.println("Error: missing message file\n");
        }
        FileInputStream inStream = null;
        try {
            inStream = FileUtils.openInputStream((File)new File(messgefile));
            MimeMessage message = new MimeMessage(null, (InputStream)inStream);
            MimeMultipart mm = (MimeMultipart)message.getContent();
            CMSSignedData signed = new CMSSignedData((CMSProcessable)new CMSProcessableBodyPart(mm.getBodyPart(0)), mm.getBodyPart(1).getInputStream());
            Store certs = signed.getCertificates();
            SignerInformationStore signers = signed.getSignerInfos();
            Collection c = signers.getSigners();
            System.out.println("Found " + c.size() + " signers");
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            int cnt = 1;
            for (SignerInformation signer : c) {
                Collection certCollection = certs.getMatches((Selector)signer.getSID());
                if (certCollection == null || certCollection.size() <= 0) continue;
                X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(((X509CertificateHolder)certCollection.iterator().next()).getEncoded()));
                System.out.println("\r\nInfo for certificate " + cnt++);
                System.out.println("\tSubject " + cert.getSubjectDN());
                FileUtils.writeByteArrayToFile((File)new File("SigCert.der"), (byte[])cert.getEncoded());
                byte[] bytes = cert.getExtensionValue("2.5.29.15");
                if (bytes != null) {
                    ASN1Object obj = MessageSigInspector.getObject(bytes);
                    KeyUsage keyUsage = KeyUsage.getInstance((Object)obj);
                    byte[] data = keyUsage.getBytes();
                    int intValue = data.length == 1 ? data[0] & 0xFF : (data[1] & 0xFF) << 8 | data[0] & 0xFF;
                    System.out.println("\tKey Usage: " + intValue);
                } else {
                    System.out.println("\tKey Usage: NONE");
                }
                Attribute digAttr = signer.getSignedAttributes().get(CMSAttributes.messageDigest);
                ASN1Encodable hashObj = digAttr.getAttrValues().getObjectAt(0);
                byte[] signedDigest = ((ASN1OctetString)hashObj).getOctets();
                String signedDigestHex = Hex.encodeHexString((byte[])signedDigest);
                System.out.println("\r\nSigned Message Digest: " + signedDigestHex);
                try {
                    signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(CryptoExtensions.getJCEProviderName()).build(cert));
                    System.out.println("Signature verified.");
                }
                catch (CMSException e) {
                    System.out.println("Signature failed to verify.");
                }
                byte[] digest = signer.getContentDigest();
                String digestHex = Hex.encodeHexString((byte[])digest);
                System.out.println("\r\nComputed Message Digest: " + digestHex);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inStream);
        }
        IOUtils.closeQuietly((InputStream)inStream);
    }

    protected static ASN1Object getObject(byte[] ext) throws PolicyProcessException {
        ASN1Primitive aSN1Primitive;
        ASN1InputStream aIn = null;
        try {
            aIn = new ASN1InputStream(ext);
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            IOUtils.closeQuietly((InputStream)aIn);
            aIn = new ASN1InputStream(octs.getOctets());
            aSN1Primitive = aIn.readObject();
        }
        catch (Exception e) {
            try {
                throw new PolicyProcessException("Exception processing data ", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(aIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)aIn);
        return aSN1Primitive;
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

