/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;

public class RawRecursiveDNSCertQuery {
    protected static List<String> dnsServers = new ArrayList<String>();

    public static void main(String[] args) {
        if (args.length == 0) {
            RawRecursiveDNSCertQuery.printUsage();
            System.exit(-1);
        }
        String emailAddress = "";
        String[] servers = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                System.err.println("Error: Unexpected argument [" + arg + "]\n");
                RawRecursiveDNSCertQuery.printUsage();
                System.exit(-1);
                continue;
            }
            if (arg.equalsIgnoreCase("-add")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing email address");
                    System.exit(-1);
                }
                emailAddress = args[++i];
                continue;
            }
            if (arg.equals("-server")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing DNS server list");
                    System.exit(-1);
                }
                servers = args[++i].split(",");
                continue;
            }
            if (arg.equals("-help")) {
                RawRecursiveDNSCertQuery.printUsage();
                System.exit(-1);
                continue;
            }
            System.err.println("Error: Unknown argument " + arg + "\n");
            RawRecursiveDNSCertQuery.printUsage();
            System.exit(-1);
        }
        if (emailAddress == null || emailAddress.isEmpty()) {
            System.err.println("You must provide an email address.");
            RawRecursiveDNSCertQuery.printUsage();
        }
        RawRecursiveDNSCertQuery.setServers(servers);
        int attemptCount = 0;
        while (true) {
            try {
                String lookupName = emailAddress.replace('@', '.');
                Lookup lu = new Lookup(new Name(lookupName), 37);
                lu.setResolver((Resolver)RawRecursiveDNSCertQuery.createExResolver(dnsServers.toArray(new String[dnsServers.size()]), 0, 6));
                lu.setSearchPath((String[])null);
                lu.setCache(new Cache(1));
                long startTime = System.currentTimeMillis();
                Record[] retRecords = lu.run();
                long endTime = System.currentTimeMillis();
                if (retRecords == null || retRecords.length == 0) {
                    System.out.println("----- Found no certificates -------");
                    System.out.println("\tDNS search took " + (endTime - startTime) + "ms\r\n");
                    System.out.println("Failed after " + attemptCount + " successful resolution attempts.");
                    System.exit(0);
                } else {
                    System.out.println("Found " + retRecords.length + " certificates");
                }
                System.out.println("\tDNS search took " + (endTime - startTime) + "ms\r\n");
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++attemptCount;
        }
    }

    public static void setServers(String[] servers) {
        if (servers == null || servers.length == 0) {
            String[] configedServers = ResolverConfig.getCurrentConfig().servers();
            if (configedServers != null) {
                dnsServers.addAll(Arrays.asList(configedServers));
            }
        } else {
            dnsServers.clear();
            dnsServers.addAll(Arrays.asList(servers));
        }
    }

    protected static ExtendedResolver createExResolver(String[] servers, int retries, int timeout) {
        ExtendedResolver retVal = null;
        for (int i = 0; servers != null && i < servers.length; ++i) {
            servers[i] = servers[i].replaceFirst("\\.$", "");
        }
        try {
            retVal = new ExtendedResolver(servers);
            retVal.setRetries(retries);
            retVal.setTimeout(timeout);
            retVal.setTCP(true);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return retVal;
    }

    private static void printUsage() {
        StringBuffer use = new StringBuffer();
        use.append("Usage:\n");
        use.append("java DNSCertDumper (options)...\n\n");
        use.append("options:\n");
        use.append("-add address\t\tEmail address of org/domain to retrieve certs for.\n");
        use.append("\n");
        use.append("-server     \t\tComma delimited list of DNS servers used for lookup.\n");
        use.append("\t\t\tDefault: Local machine's configured DNS server(s)\n\n");
        use.append("-out  Out File\t\tOptional output file name for the cert.\n");
        use.append("\t\t\tDefault: <email address>(<cert num>).der\n\n");
        System.err.println(use);
    }
}

