/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography.bc;

import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientOperator;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipient;
import org.bouncycastle.jcajce.io.CipherInputStream;
import org.bouncycastle.operator.InputDecryptor;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JceAsymmetricKeyUnwrapper;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.stagent.cryptography.bc.DirectEnvelopedDataHelper;
import org.nhindirect.stagent.cryptography.bc.DirectNamedJcaJceExtHelper;
import org.nhindirect.stagent.cryptography.bc.DirectProviderJcaJceExtHelper;

public class DirectJceKeyTransEnvelopedRecipient
extends JceKeyTransEnvelopedRecipient {
    protected DirectEnvelopedDataHelper helper;
    protected DirectEnvelopedDataHelper contentHelper;
    protected PrivateKey recipientKey;

    public DirectJceKeyTransEnvelopedRecipient(PrivateKey recipientKey) {
        super(recipientKey);
        this.contentHelper = this.helper;
        this.recipientKey = recipientKey;
        this.setProvider(CryptoExtensions.getJCEProviderName());
    }

    public JceKeyTransRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new DirectEnvelopedDataHelper(new DirectProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceKeyTransRecipient setProvider(String providerName) {
        this.contentHelper = this.helper = new DirectEnvelopedDataHelper(new DirectNamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceKeyTransRecipient setContentProvider(Provider provider) {
        this.contentHelper = DirectJceKeyTransEnvelopedRecipient.createContentHelper(provider);
        return this;
    }

    public JceKeyTransRecipient setContentProvider(String providerName) {
        this.contentHelper = DirectJceKeyTransEnvelopedRecipient.createContentHelper(providerName);
        return this;
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        Key secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Cipher dataCipher = this.contentHelper.createContentCipher(secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            public InputStream getInputStream(InputStream dataIn) {
                return new CipherInputStream(dataIn, dataCipher);
            }
        });
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier encryptedKeyAlgorithm, byte[] encryptedEncryptionKey) throws CMSException {
        JceAsymmetricKeyUnwrapper unwrapper = this.helper.createAsymmetricUnwrapper(keyEncryptionAlgorithm, this.recipientKey).setMustProduceEncodableUnwrappedKey(this.unwrappedKeyMustBeEncodable);
        if (!this.extraMappings.isEmpty()) {
            for (ASN1ObjectIdentifier algorithm : this.extraMappings.keySet()) {
                unwrapper.setAlgorithmMapping(algorithm, (String)this.extraMappings.get(algorithm));
            }
        }
        try {
            Key key = this.helper.getJceKey(encryptedKeyAlgorithm.getAlgorithm(), unwrapper.generateUnwrappedKey(encryptedKeyAlgorithm, encryptedEncryptionKey));
            if (this.validateKeySize) {
                this.helper.keySizeCheck(encryptedKeyAlgorithm, key);
            }
            return key;
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    static DirectEnvelopedDataHelper createContentHelper(Provider provider) {
        if (provider != null) {
            return new DirectEnvelopedDataHelper(new DirectProviderJcaJceExtHelper(provider));
        }
        return new DirectEnvelopedDataHelper(new DirectNamedJcaJceExtHelper(CryptoExtensions.getJCEProviderName()));
    }

    static DirectEnvelopedDataHelper createContentHelper(String providerName) {
        if (providerName != null) {
            return new DirectEnvelopedDataHelper(new DirectNamedJcaJceExtHelper(providerName));
        }
        return new DirectEnvelopedDataHelper(new DirectNamedJcaJceExtHelper(CryptoExtensions.getJCEProviderName()));
    }
}

