/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.commons.io.IOUtils;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;

public class EntitySerializer {
    public static final EntitySerializer Default = new EntitySerializer();

    public void serialize(MimePart message, OutputStream stream) {
        try {
            message.writeTo(stream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
    }

    public void serialize(MimePart message, Writer writer) {
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            this.serialize(message, oStream);
            oStream.flush();
            IOUtils.write((byte[])oStream.toByteArray(), (Writer)writer, (String)"ASCII");
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
    }

    public String serialize(MimePart message) {
        String retVal = "";
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            this.serialize(message, oStream);
            oStream.flush();
            retVal = oStream.toString("ASCII");
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        return retVal;
    }

    public byte[] serializeToBytes(MimePart message) {
        byte[] retVal;
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            this.serialize(message, oStream);
            oStream.flush();
            retVal = oStream.toByteArray();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        return retVal;
    }

    public void serialize(Collection<MimeBodyPart> parts, String boundary, Writer writer) {
        if (parts == null || parts.size() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            this.serialize(parts, boundary, oStream);
            oStream.flush();
            String str = oStream.toString("ASCII");
            writer.write(str, 0, str.length());
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
    }

    public String serialize(Collection<MimeBodyPart> parts, String boundary) {
        String retVal = "";
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            this.serialize(parts, boundary, oStream);
            oStream.flush();
            retVal = oStream.toString("ASCII");
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        return retVal;
    }

    public void serialize(Collection<MimeBodyPart> parts, String boundary, OutputStream stream) {
        if (parts == null || parts.size() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            MimeMultipart mm = new MimeMultipart();
            for (MimeBodyPart part : parts) {
                mm.addBodyPart((BodyPart)part);
            }
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            mm.writeTo((OutputStream)oStream);
            oStream.flush();
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
    }

    public byte[] serializeToBytes(Collection<MimeBodyPart> parts, String boundary) {
        byte[] retVal = null;
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            this.serialize(parts, boundary, oStream);
            oStream.flush();
            retVal = oStream.toByteArray();
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        return retVal;
    }

    public MimeMessage deserialize(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException();
        }
        MimeMessage msg = null;
        try {
            msg = new MimeMessage(null, stream);
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.Unexpected, (Exception)((Object)e));
        }
        return msg;
    }

    public MimeMessage deserialize(Reader reader) {
        MimeMessage retVal = null;
        if (reader == null) {
            throw new IllegalArgumentException();
        }
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(IOUtils.toByteArray((Reader)reader, (String)"ASCII"));
            retVal = this.deserialize(inStream);
        }
        catch (IOException e) {
            throw new MimeException(MimeError.Unexpected, (Exception)e);
        }
        return retVal;
    }

    public MimeMessage deserialize(String messageText) {
        MimeMessage retVal = null;
        if (messageText == null || messageText.length() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(messageText.getBytes("ASCII"));
            retVal = this.deserialize(inStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        return retVal;
    }

    public MimeMessage deserialize(byte[] messageBytes) {
        MimeMessage retVal = null;
        if (messageBytes == null || messageBytes.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(messageBytes);
            retVal = this.deserialize(inStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        return retVal;
    }
}

