/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.notifications.MDNStandard;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationCreator;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.mail.notifications.SendType;
import org.nhindirect.stagent.mail.notifications.TriggerType;

public class NotificationHelper {
    public static boolean hasNotificationRequest(Message message) {
        String[] header = null;
        try {
            header = message.getHeader("Disposition-Notification-To");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return header != null && header.length > 0;
    }

    public static boolean isMDN(Message message) {
        return MDNStandard.isReport(message);
    }

    public static boolean shouldIssueNotification(Message message) {
        return !NotificationHelper.isMDN(message) && NotificationHelper.hasNotificationRequest(message);
    }

    public static String getNotificationDestination(Message message) {
        String retVal = "";
        try {
            String[] destinations = message.getHeader("Disposition-Notification-To");
            if (destinations == null || destinations.length == 0) {
                destinations = message.getHeader("from");
            }
            if (destinations == null || destinations.length == 0) {
                retVal = "";
            } else if (destinations.length == 1) {
                retVal = destinations[0];
            } else if (destinations.length > 1) {
                ArrayList<String> uniqueDestinations = new ArrayList<String>();
                Collections.addAll(uniqueDestinations, destinations);
                TreeSet seen = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                uniqueDestinations.removeIf(s -> !seen.add(s));
                retVal = String.join((CharSequence)",", uniqueDestinations);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
        return retVal != null ? retVal : "";
    }

    public static Collection<InternetAddress> getNotificationDestinationAddresses(Message message) {
        String rawAddresses = NotificationHelper.getNotificationDestination(message);
        if (rawAddresses.isEmpty()) {
            return Collections.emptyList();
        }
        InternetAddress[] addresses = null;
        try {
            addresses = InternetAddress.parse((String)rawAddresses);
        }
        catch (AddressException addressException) {
            // empty catch block
        }
        List<Object> retVal = addresses != null ? Arrays.asList(addresses) : Collections.emptyList();
        return retVal;
    }

    public static void requestNotification(Message message) {
        if (NotificationHelper.isMDN(message)) {
            throw new IllegalStateException("Cannot request an MDN for an MDN");
        }
        try {
            message.setHeader("Disposition-Notification-To", message.getHeader("from", ","));
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public static NotificationMessage createNotificationMessage(Message message, InternetAddress from, Notification notification) {
        if (from == null) {
            throw new IllegalArgumentException();
        }
        if (notification == null) {
            throw new IllegalArgumentException();
        }
        if (NotificationHelper.isMDN(message)) {
            return null;
        }
        notification.setFinalRecipient(from.getAddress());
        NotificationMessage notificationMessage = NotificationMessage.createNotificationFor(message, notification);
        if (notificationMessage != null) {
            try {
                notificationMessage.setFrom((Address)from);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
        return notificationMessage;
    }

    public static Collection<NotificationMessage> createNotificationMessages(Message message, Collection<InternetAddress> senders, NotificationCreator notificationCreator) {
        if (senders == null) {
            throw new IllegalArgumentException();
        }
        if (notificationCreator == null) {
            throw new IllegalArgumentException();
        }
        if (NotificationHelper.isMDN(message)) {
            return Collections.emptyList();
        }
        ArrayList<NotificationMessage> retVal = new ArrayList<NotificationMessage>();
        for (InternetAddress sender : senders) {
            Notification notification;
            NotificationMessage notificationMessage = NotificationHelper.createNotificationMessage(message, sender, notification = notificationCreator.createNotification(sender));
            if (notificationMessage == null) continue;
            retVal.add(notificationMessage);
        }
        return retVal;
    }

    public static String asString(TriggerType type) {
        return MDNStandard.toString(type);
    }

    public static String asString(SendType type) {
        return MDNStandard.toString(type);
    }

    public static String asString(NotificationType type) {
        return NotificationHelper.asString(type, false);
    }

    public static String asString(NotificationType type, boolean cap) {
        String retVal = MDNStandard.toString(type);
        if (cap) {
            char[] asArray = retVal.toCharArray();
            asArray[0] = Character.toTitleCase(asArray[0]);
            retVal = new String(asArray);
        }
        return retVal;
    }
}

