/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.ldap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.directory.server.core.configuration.MutablePartitionConfiguration;
import org.apache.directory.server.unit.AbstractServerTest;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.nhindirect.ldap.PrivkeySchema;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.LDAPCertificateStore;
import org.nhindirect.stagent.cert.impl.LdapCertificateStoreFactory;
import org.nhindirect.stagent.cert.impl.LdapStoreConfiguration;

public class LDAPResearchTest
extends AbstractServerTest {
    public void setUp() throws Exception {
        MutablePartitionConfiguration pcfg = new MutablePartitionConfiguration();
        pcfg.setName("lookupTest");
        pcfg.setSuffix("cn=lookupTest");
        HashSet<String> indexedAttrs = new HashSet<String>();
        indexedAttrs.add("objectClass");
        indexedAttrs.add("cn");
        pcfg.setIndexedAttributes(indexedAttrs);
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute attr = new BasicAttribute("objectClass");
        attr.add("top");
        attrs.put(attr);
        pcfg.setContextEntry((Attributes)attrs);
        HashSet<MutablePartitionConfiguration> pcfgs = new HashSet<MutablePartitionConfiguration>();
        pcfgs.add(pcfg);
        this.configuration.setContextPartitionConfigurations(pcfgs);
        this.configuration.setWorkingDirectory(new File("LDAP-TEST"));
        Set schemas = this.configuration.getBootstrapSchemas();
        schemas.add(new PrivkeySchema());
        this.configuration.setBootstrapSchemas(schemas);
        super.setUp();
        InputStream stream = LDAPResearchTest.class.getClassLoader().getResourceAsStream("ldifs/privCertsOnly.ldif");
        if (stream == null) {
            throw new IOException("Failed to load ldif file");
        }
        this.importLdif(stream);
        this.createLdapEntries();
    }

    private DirContext createContext(String partition) throws Exception {
        int port = this.configuration.getLdapPort();
        String url = "ldap://localhost:" + port + "/" + partition;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        InitialContext initialContext = new InitialContext(env);
        LDAPResearchTest.assertNotNull((Object)initialContext);
        return (DirContext)initialContext.lookup("");
    }

    public void testDummy() throws Exception {
        CertCacheFactory.getInstance().flushAll();
        DirContext dirContext = this.createContext("cn=lookupTest");
        Attributes attributes = dirContext.getAttributes("");
        LDAPResearchTest.assertNotNull((Object)attributes);
        NamingEnumeration<? extends Attribute> namingEnum = attributes.getAll();
        while (namingEnum.hasMoreElements()) {
            Attribute attr = (Attribute)namingEnum.nextElement();
            System.out.println("Name: " + attr.getID() + "\r\nValue: " + attr.get() + "\r\n\r\n");
        }
        Set<SearchResult> results = this.searchDNs("(email=gm2552@cerner.com)", "", "ou=privKeys, ou=cerner, ou=com", 2, dirContext);
        for (SearchResult result : results) {
            System.out.println(result.getName());
            String privKey = (String)result.getAttributes().get("privKeyStore").get();
            System.out.println("Privkey BASE64: " + privKey);
        }
    }

    public void testLdapSearch() throws Exception {
        CertCacheFactory.getInstance().flushAll();
        int port = this.configuration.getLdapPort();
        String url = "ldap://localhost:" + port + "/cn=lookupTest";
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        InitialContext initialContext = new InitialContext(env);
        LDAPResearchTest.assertNotNull((Object)initialContext);
        DirContext dirContext = (DirContext)initialContext.lookup("");
        Attributes attributes = dirContext.getAttributes("");
        LDAPResearchTest.assertNotNull((Object)attributes);
        NamingEnumeration<? extends Attribute> namingEnum = attributes.getAll();
        while (namingEnum.hasMoreElements()) {
            Attribute attr = (Attribute)namingEnum.nextElement();
            System.out.println("Name: " + attr.getID() + "\r\nValue: " + attr.get() + "\r\n\r\n");
        }
        LdapStoreConfiguration ldapStoreConfiguration = new LdapStoreConfiguration(new String[]{url}, "", "email", "privKeyStore", "X509");
        LDAPCertificateStore certificateResolver = (LDAPCertificateStore)LdapCertificateStoreFactory.createInstance((LdapStoreConfiguration)ldapStoreConfiguration, null, null);
        Collection certs = certificateResolver.getCertificates("gm2552@cerner.com");
        LDAPResearchTest.assertEquals((int)1, (int)certs.size());
        X509Certificate cert = (X509Certificate)certs.iterator().next();
        LDAPResearchTest.assertFalse((boolean)(cert instanceof X509CertificateEx));
        LDAPResearchTest.assertTrue((boolean)cert.getSubjectX500Principal().toString().contains("bob@nhind.hsgincubator.com"));
    }

    protected void createLdapEntries() throws NamingException {
        Entry entry = new Entry();
        entry.addAttribute("objectClass", (Object)"organizationalUnit");
        entry.addAttribute("objectClass", (Object)"top");
        entry.addAttribute("objectClass", (Object)"userPrivKey");
        entry.addAttribute("email", (Object)"gm2552@cerner.com");
        File fl = new File("testfile");
        int idx = fl.getAbsolutePath().lastIndexOf("testfile");
        String path = fl.getAbsolutePath().substring(0, idx);
        byte[] buffer = new byte[(int)new File(path + "src/test/resources/certs/bob.der").length() + 100];
        try {
            InputStream stream = LDAPResearchTest.class.getClassLoader().getResourceAsStream("certs/bob.der");
            stream.read(buffer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Base64 base64 = new Base64();
        String certificateValue = new String(base64.encode(buffer));
        entry.addAttribute("privKeyStore", (Object)certificateValue);
        entry.addAttribute("ou", (Object)"gm2552");
        this.rootDSE.createSubcontext("ou=gm2552, ou=privKeys, ou=cerner, ou=com, cn=lookupTest", entry.getAttributes());
    }

    private Set<SearchResult> searchDNs(String filter, String partition, String base, int scope, DirContext appRoot) throws Exception {
        if (appRoot == null) {
            appRoot = this.createContext(partition);
        }
        SearchControls controls = new SearchControls();
        controls.setSearchScope(scope);
        NamingEnumeration<SearchResult> result = appRoot.search(base, filter, controls);
        HashSet<SearchResult> entries = new HashSet<SearchResult>();
        while (result.hasMore()) {
            SearchResult entry = result.next();
            entries.add(entry);
        }
        return entries;
    }
}

