/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.cert.impl.CRLRevocationManager;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;

public class CRLManagerTest {
    private static final String KEY_STORE_PASSWORD = "h3||0 wor|d";
    private static final String PRIVATE_KEY_PASSWORD = "pKpa$$wd";

    @Test
    public void testCrlManager() {
        String tmp = this.getClass().getClassLoader().getResource("crl/certs.crl").getPath();
        final String workingDir = tmp.substring(0, tmp.lastIndexOf("/") + 1).replaceAll("%20", " ");
        String internalKeystoreFile = workingDir + "keystore";
        KeyStoreCertificateStore service = new KeyStoreCertificateStore(internalKeystoreFile, KEY_STORE_PASSWORD, PRIVATE_KEY_PASSWORD);
        CRLRevocationManager crlManager = new CRLRevocationManager(){

            protected String getNameString(String generalNameString) {
                String s = super.getNameString(generalNameString);
                return s.replace("http://JUNIT", "file://" + workingDir);
            }
        };
        Assertions.assertEquals((Object)false, (Object)crlManager.isRevoked(null));
        Assertions.assertEquals((Object)false, (Object)crlManager.isRevoked(service.getByAlias("valid")));
        Assertions.assertEquals((Object)true, (Object)crlManager.isRevoked(service.getByAlias("revoked")));
        Assertions.assertEquals((Object)false, (Object)crlManager.isRevoked(service.getByAlias("gm2552")));
        Assertions.assertEquals((Object)false, (Object)crlManager.isRevoked(service.getByAlias("missing")));
        Assertions.assertEquals((Object)false, (Object)crlManager.isRevoked(null));
        Assertions.assertEquals((Object)false, (Object)crlManager.isRevoked(service.getByAlias("valid")));
        Assertions.assertEquals((Object)true, (Object)crlManager.isRevoked(service.getByAlias("revoked")));
        Assertions.assertEquals((Object)false, (Object)crlManager.isRevoked(service.getByAlias("gm2552")));
        Assertions.assertEquals((Object)false, (Object)crlManager.isRevoked(service.getByAlias("missing")));
    }
}

