/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class DefaultNHINDAgent_ProcessOutgoing_AsRawString_Test {
    @Test
    public void testMessageTxtIsNull_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected String createMessageText() throws Exception {
                this.theCreateMessageText = null;
                return this.theCreateMessageText;
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                Assertions.fail((String)"");
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                org.junit.jupiter.api.Assertions.assertNull((Object)this.theCreateMessageText);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    @Test
    public void testMessageTxtIsBlank_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected String createMessageText() throws Exception {
                this.theCreateMessageText = "";
                return this.theCreateMessageText;
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                Assertions.fail((String)"");
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)this.theCreateMessageText.length());
                org.junit.jupiter.api.Assertions.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    @Test
    public void testCorrectMessageTxtParamIsPassedToWrapMessage() throws Exception {
        new TestPlan(){

            @Override
            protected Message wrapMessage_Internal(String messageText) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)this.theCreateMessageText, (Object)messageText);
                return super.wrapMessage_Internal(messageText);
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.wrapMessageCalls);
            }
        }.perform();
    }

    @Test
    public void testMessageTxtIsValid_ProcessOutgoingMethodIsCalled() throws Exception {
        new TestPlan(){

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.processOutgoingCalls);
                org.junit.jupiter.api.Assertions.assertNotNull((Object)this.theProcessOutgoing);
                org.junit.jupiter.api.Assertions.assertEquals((Object)this.theProcessOutgoing, (Object)processOutgoing);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected Message theWrapMessage;
        protected int wrapMessageCalls = 0;
        protected OutgoingMessage theProcessOutgoing;
        protected int processOutgoingCalls = 0;
        protected String theCreateMessageText;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createDefaultNHINDAgent();
            OutgoingMessage processOutgoing = impl.processOutgoing(this.createMessageText());
            this.doAssertions(processOutgoing);
        }

        protected DefaultNHINDAgent createDefaultNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                protected Message wrapMessage(String messageText) {
                    ++TestPlan.this.wrapMessageCalls;
                    return TestPlan.this.wrapMessage_Internal(messageText);
                }

                public OutgoingMessage processOutgoing(OutgoingMessage message) {
                    ++TestPlan.this.processOutgoingCalls;
                    return TestPlan.this.processOutgoing_Internal(message);
                }
            };
        }

        protected Message wrapMessage_Internal(String messageText) {
            try {
                Message msg;
                SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
                mimeMsg.setText("");
                mimeMsg.setRecipients(Message.RecipientType.TO, "some");
                mimeMsg.setSender((Address)new InternetAddress("some"));
                this.theWrapMessage = msg = new Message((MimeMessage)mimeMsg);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)"");
            }
            return this.theWrapMessage;
        }

        protected OutgoingMessage processOutgoing_Internal(OutgoingMessage message) {
            this.theProcessOutgoing = message;
            return this.theProcessOutgoing;
        }

        protected String createMessageText() throws Exception {
            this.theCreateMessageText = "createMessageText";
            return this.theCreateMessageText;
        }

        protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
        }
    }
}

