/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.mail.internet.InternetAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAgent;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.policy.PolicyResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.TestUtils;

public class DefaultNHINDAgent_bindAddressesOutgoingMessageTest {
    protected OutgoingMessage buildOutgoingMessage(String fileName) throws Exception {
        String testMessage = TestUtils.readResource(fileName);
        Message incoming = new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        return new OutgoingMessage(incoming);
    }

    @Test
    public void testBindAddresses_noPrivateCerts_assertNoBoundPrivateCerts() throws Exception {
        CertificateResolver publicCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)publicCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(new ArrayList());
        CertificateResolver privateCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)privateCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(new ArrayList());
        DefaultNHINDAgent agent = new DefaultNHINDAgent("Cerner.com", privateCertResolver, publicCertResolver, (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        OutgoingMessage message = this.buildOutgoingMessage("MultipartMimeMessage.txt");
        message.setAgent((NHINDAgent)agent);
        agent.bindAddresses(message);
        Assertions.assertEquals((int)0, (int)message.getSender().getCertificates().size());
    }

    @Test
    public void testBindAddresses_singlePrivateCerts_notFiltered_assertBoundPrivateCerts() throws Exception {
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        CertificateResolver publicCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)publicCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(new ArrayList());
        CertificateResolver privateCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)privateCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(Arrays.asList(cert));
        DefaultNHINDAgent agent = new DefaultNHINDAgent("Cerner.com", privateCertResolver, publicCertResolver, (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        OutgoingMessage message = this.buildOutgoingMessage("MultipartMimeMessage.txt");
        message.setAgent((NHINDAgent)agent);
        agent.bindAddresses(message);
        Assertions.assertEquals((int)1, (int)message.getSender().getCertificates().size());
    }

    @Test
    public void testBindAddresses_singlePrivateCerts_policyFiltered_assertNoBoundPrivateCerts() throws Exception {
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        CertificateResolver publicCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)publicCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(new ArrayList());
        CertificateResolver privateCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)privateCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(Arrays.asList(cert));
        DefaultNHINDAgent agent = new DefaultNHINDAgent("Cerner.com", privateCertResolver, publicCertResolver, (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class)){

            protected Collection<X509Certificate> filterCertificatesByPolicy(InternetAddress sender, PolicyResolver resolver, Collection<X509Certificate> certsToFilter, boolean incoming) {
                return Collections.emptyList();
            }
        };
        OutgoingMessage message = this.buildOutgoingMessage("MultipartMimeMessage.txt");
        message.setAgent((NHINDAgent)agent);
        agent.bindAddresses(message);
        Assertions.assertEquals((int)0, (int)message.getSender().getCertificates().size());
    }

    @Test
    public void testBindAddresses_noPublicCerts_assertNoBoundPublicCerts() throws Exception {
        CertificateResolver publicCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)publicCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(new ArrayList());
        CertificateResolver privateCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)privateCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(new ArrayList());
        DefaultNHINDAgent agent = new DefaultNHINDAgent("Cerner.com", privateCertResolver, publicCertResolver, (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        OutgoingMessage message = this.buildOutgoingMessage("MultipartMimeMessage.txt");
        message.setAgent((NHINDAgent)agent);
        agent.bindAddresses(message);
        for (NHINDAddress recipient : message.getRecipients()) {
            Assertions.assertEquals((int)0, (int)recipient.getCertificates().size());
        }
    }

    @Test
    public void testBindAddresses_singlePublicCerts_notFiltered_assertSingleBoundPublicCerts() throws Exception {
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        CertificateResolver publicCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)publicCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(Arrays.asList(cert));
        CertificateResolver privateCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)privateCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(new ArrayList());
        DefaultNHINDAgent agent = new DefaultNHINDAgent("Cerner.com", privateCertResolver, publicCertResolver, (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        OutgoingMessage message = this.buildOutgoingMessage("MultipartMimeMessage.txt");
        message.setAgent((NHINDAgent)agent);
        agent.bindAddresses(message);
        for (NHINDAddress recipient : message.getRecipients()) {
            Assertions.assertEquals((int)1, (int)recipient.getCertificates().size());
        }
    }

    @Test
    public void testBindAddresses_singlePublicCerts_policyFiltered_assertNoBoundPublicCerts() throws Exception {
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        CertificateResolver publicCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)publicCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(Arrays.asList(cert));
        CertificateResolver privateCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)privateCertResolver.getCertificates((InternetAddress)ArgumentMatchers.any())).thenReturn(new ArrayList());
        DefaultNHINDAgent agent = new DefaultNHINDAgent("Cerner.com", privateCertResolver, publicCertResolver, (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class)){

            protected Collection<X509Certificate> filterCertificatesByPolicy(InternetAddress sender, PolicyResolver resolver, Collection<X509Certificate> certsToFilter, boolean incoming) {
                return Collections.emptyList();
            }
        };
        OutgoingMessage message = this.buildOutgoingMessage("MultipartMimeMessage.txt");
        message.setAgent((NHINDAgent)agent);
        agent.bindAddresses(message);
        for (NHINDAddress recipient : message.getRecipients()) {
            Assertions.assertEquals((int)0, (int)recipient.getCertificates().size());
        }
    }
}

