/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.mail.Header;
import javax.mail.internet.MimeMessage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsManagerUtils;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.MessageEnvelope;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustError;
import org.nhindirect.stagent.utils.TestUtils;

public class NHINDAgentTest {
    @BeforeEach
    public void setUp() {
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    @AfterEach
    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerOptions();
    }

    @Test
    public void testEndToEndMessageWithCertKeyStore() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("cerner.com"));
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        MimeMessage originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        Assertions.assertNotNull((Object)SMIMEenvMessage);
        Assertions.assertTrue((SMIMEenvMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming(SMIMEenvMessage.getMessage().toString());
        Assertions.assertNotNull((Object)strippedAndVerifiesMessage);
        Assertions.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        MimeMessage processedMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(strippedAndVerifiesMessage.getMessage().toString().getBytes("ASCII")));
        Assertions.assertNotNull((Object)processedMsg);
        Assertions.assertTrue((processedMsg.getContentType().compareTo(originalMsg.getContentType()) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((originalMsg.getSubject().compareTo(processedMsg.getSubject()) == 0 ? 1 : 0) != 0);
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int count = 0;
        InputStream inStream = originalMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        oStream = new ByteArrayOutputStream();
        count = 0;
        inStream = processedMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        testMessage = TestUtils.readResource("LargeMsgWithAttachments.txt");
        originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        SMIMEenvMessage = agent.processOutgoing(testMessage);
        Assertions.assertNotNull((Object)SMIMEenvMessage);
        Assertions.assertTrue((SMIMEenvMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        strippedAndVerifiesMessage = agent.processIncoming((MessageEnvelope)SMIMEenvMessage);
        Assertions.assertNotNull((Object)strippedAndVerifiesMessage);
        Assertions.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        processedMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(strippedAndVerifiesMessage.getMessage().toString().getBytes("ASCII")));
        Assertions.assertNotNull((Object)processedMsg);
        Assertions.assertTrue((processedMsg.getContentType().compareTo(originalMsg.getContentType()) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((originalMsg.getSubject().compareTo(processedMsg.getSubject()) == 0 ? 1 : 0) != 0);
        oStream = new ByteArrayOutputStream();
        buffer = new byte[1024];
        count = 0;
        inStream = originalMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        oStream = new ByteArrayOutputStream();
        count = 0;
        inStream = processedMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        agent = TestUtils.getStockAgent(Arrays.asList("cerner.com"));
        testMessage = TestUtils.readResource("MDNResponse.txt");
        originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        SMIMEenvMessage = agent.processOutgoing(testMessage);
        Assertions.assertNotNull((Object)SMIMEenvMessage);
        Assertions.assertTrue((SMIMEenvMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        strippedAndVerifiesMessage = agent.processIncoming((MessageEnvelope)SMIMEenvMessage);
        Assertions.assertNotNull((Object)strippedAndVerifiesMessage);
        Assertions.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        processedMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(strippedAndVerifiesMessage.getMessage().toString().getBytes("ASCII")));
        Assertions.assertNotNull((Object)processedMsg);
        Assertions.assertTrue((processedMsg.getContentType().compareTo(originalMsg.getContentType()) == 0 ? 1 : 0) != 0);
        oStream = new ByteArrayOutputStream();
        buffer = new byte[1024];
        count = 0;
        inStream = originalMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        oStream = new ByteArrayOutputStream();
        count = 0;
        inStream = processedMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
    }

    @Test
    public void testDecryptProvidedMessage() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        String testMessage = TestUtils.readResource("EncryptedMessage2.txt");
        MimeMessage originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming(originalMsg);
        Assertions.assertNotNull((Object)strippedAndVerifiesMessage);
        Assertions.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRejectMessageOnRoutingTamper_policyTrue_assertMessageRejected() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("REJECT_ON_ROUTING_TAMPER", "true"));
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        String testMessage = TestUtils.readResource("EncryptedMessage2.txt");
        Message originalMsg = new Message(new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII"))));
        NHINDAddressCollection tamperedRecips = new NHINDAddressCollection();
        tamperedRecips.add((Object)new NHINDAddress("ryan@securehealthemail.com"));
        tamperedRecips.add((Object)new NHINDAddress("john@securehealthemail.com"));
        IncomingMessage inMessage = new IncomingMessage(originalMsg, tamperedRecips, new NHINDAddress(originalMsg.getFrom()[0].toString()));
        boolean exceptionOccured = false;
        try {
            agent.processIncoming(inMessage);
        }
        catch (AgentException e) {
            Assertions.assertEquals((Object)AgentError.MessageTamperDectection, (Object)e.getError());
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        OptionsManager.destroyInstance();
    }

    @Test
    public void testRejectMessageOnRoutingTamper_policyFalse_assertDecrtyped() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("REJECT_ON_ROUTING_TAMPER", "false"));
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        String testMessage = TestUtils.readResource("EncryptedMessage2.txt");
        Message originalMsg = new Message(new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII"))));
        NHINDAddressCollection tamperedRecips = new NHINDAddressCollection();
        tamperedRecips.add((Object)new NHINDAddress("ryan@securehealthemail.com"));
        tamperedRecips.add((Object)new NHINDAddress("john@securehealthemail.com"));
        IncomingMessage inMessage = new IncomingMessage(originalMsg, tamperedRecips, new NHINDAddress(originalMsg.getFrom()[0].toString()));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming(inMessage);
        Assertions.assertNotNull((Object)strippedAndVerifiesMessage);
        Assertions.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDecryptAttachmentMessage() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        String testMessage = TestUtils.readResource("EncAttachment.txt");
        MimeMessage originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming(originalMsg);
        Assertions.assertNotNull((Object)strippedAndVerifiesMessage);
        Assertions.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEndToEndMessageBase64AttachmentOnly() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("messaging.cernerdemos.com"));
        String testMessage = TestUtils.readResource("raw2.txt");
        MimeMessage originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        Assertions.assertNotNull((Object)SMIMEenvMessage);
        Assertions.assertTrue((SMIMEenvMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming((MessageEnvelope)SMIMEenvMessage);
        Assertions.assertNotNull((Object)strippedAndVerifiesMessage);
        Assertions.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        MimeMessage processedMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(strippedAndVerifiesMessage.getMessage().toString().getBytes("ASCII")));
        Assertions.assertNotNull((Object)processedMsg);
        Assertions.assertTrue((processedMsg.getContentType().compareTo(originalMsg.getContentType()) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((originalMsg.getSubject().compareTo(processedMsg.getSubject()) == 0 ? 1 : 0) != 0);
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int count = 0;
        InputStream inStream = originalMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        oStream = new ByteArrayOutputStream();
        count = 0;
        inStream = processedMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
    }

    @Test
    public void testOutgoingMessageIsWrappedCorrectly() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("messaging.cernerdemos.com"));
        String testMessage = TestUtils.readResource("raw2.txt");
        Message wrappedMessage = agent.wrapMessage(testMessage);
        Assertions.assertNotNull((Object)wrappedMessage);
        Assertions.assertTrue((wrappedMessage.toString().length() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"message/rfc822", (Object)wrappedMessage.getContentType());
        ArrayList<String> headers = new ArrayList<String>();
        Enumeration allHeaders = wrappedMessage.getAllHeaders();
        while (allHeaders.hasMoreElements()) {
            Header header = (Header)allHeaders.nextElement();
            headers.add(header.getName());
        }
        Assertions.assertTrue((boolean)headers.contains("MIME-Version"));
        Assertions.assertTrue((boolean)headers.contains("From"));
        Assertions.assertTrue((boolean)headers.contains("To"));
        Assertions.assertTrue((boolean)headers.contains("Message-ID"));
        Assertions.assertFalse((boolean)headers.contains("Subject"));
    }

    @Test
    public void testMessageWithUntrustedRecipient_OutboundMessageHasRejectedRecips() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("messaging.cernerdemos.com"));
        String testMessage = TestUtils.readResource("MessageWithAUntrustedRecipient.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        Assertions.assertNotNull((Object)SMIMEenvMessage);
        Assertions.assertTrue((SMIMEenvMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)SMIMEenvMessage.hasRejectedRecipients());
        Assertions.assertNull((Object)SMIMEenvMessage.getMessage().getCCHeader());
        agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming((MessageEnvelope)SMIMEenvMessage);
        Assertions.assertNotNull((Object)strippedAndVerifiesMessage);
        Assertions.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        MimeMessage processedMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(strippedAndVerifiesMessage.getMessage().toString().getBytes("ASCII")));
        Assertions.assertNotNull((Object)processedMsg);
    }

    @Test
    public void testMessageWithAllUntrustedRecipients_AgentRejectsTheMessageCompletely() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("messaging.cernerdemos.com"));
        String testMessage = TestUtils.readResource("MessageWithAllUntrustedRecipients.txt");
        OutgoingMessage SMIMEenvMessage = null;
        try {
            SMIMEenvMessage = agent.processOutgoing(testMessage);
        }
        catch (NHINDException e) {
            AgentError agentError = (AgentError)e.m_error;
            Assertions.assertEquals((Object)AgentError.Unexpected, (Object)agentError);
        }
        Assertions.assertNull((Object)SMIMEenvMessage);
    }

    @Test
    public void testIncomingMDN_incomingNotTrusted_outgoingTrusted_assertMDNMessageTrusted() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("UseOutgoingPolicyForIncomingNotifications", "true"));
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        String testMessage = TestUtils.readResource("MDNMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        Assertions.assertNotNull((Object)SMIMEenvMessage);
        agent = TestUtils.getStockAgent(Arrays.asList("Cerner.com"));
        DefaultTrustAnchorResolver resolver = (DefaultTrustAnchorResolver)agent.getTrustAnchors();
        CertificateResolver mockResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        DefaultTrustAnchorResolver newResolver = new DefaultTrustAnchorResolver(resolver.getOutgoingAnchors(), mockResolver);
        agent.setTrustAnchorResolver((TrustAnchorResolver)newResolver);
        IncomingMessage incomingMessage = agent.processIncoming((MimeMessage)SMIMEenvMessage.getMessage());
        Assertions.assertNotNull((Object)incomingMessage);
    }

    @Test
    public void testIncomingDSN_incomingNotTrusted_outgoingTrusted_assertMDNMessageTrusted() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("UseOutgoingPolicyForIncomingNotifications", "true"));
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        String testMessage = TestUtils.readResource("DSNMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        Assertions.assertNotNull((Object)SMIMEenvMessage);
        agent = TestUtils.getStockAgent(Arrays.asList("Cerner.com"));
        DefaultTrustAnchorResolver resolver = (DefaultTrustAnchorResolver)agent.getTrustAnchors();
        CertificateResolver mockResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        DefaultTrustAnchorResolver newResolver = new DefaultTrustAnchorResolver(resolver.getOutgoingAnchors(), mockResolver);
        agent.setTrustAnchorResolver((TrustAnchorResolver)newResolver);
        IncomingMessage incomingMessage = agent.processIncoming((MimeMessage)SMIMEenvMessage.getMessage());
        Assertions.assertNotNull((Object)incomingMessage);
    }

    @Test
    public void testIncomingNormalMessage_incomingNotTrusted_outgoingTrusted_assertMessageNotTrusted() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("cerner.com"));
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        Assertions.assertNotNull((Object)SMIMEenvMessage);
        agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        DefaultTrustAnchorResolver resolver = (DefaultTrustAnchorResolver)agent.getTrustAnchors();
        CertificateResolver mockResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        DefaultTrustAnchorResolver newResolver = new DefaultTrustAnchorResolver(resolver.getOutgoingAnchors(), mockResolver);
        agent.setTrustAnchorResolver((TrustAnchorResolver)newResolver);
        IncomingMessage incomingMessage = null;
        try {
            incomingMessage = agent.processIncoming((MimeMessage)SMIMEenvMessage.getMessage());
        }
        catch (NHINDException e) {
            Assertions.assertEquals((Object)TrustError.NoTrustedRecipients, (Object)e.getError());
        }
        Assertions.assertNull((Object)incomingMessage);
    }

    @Test
    public void testIncomingMDN_incomingNotTrusted_outgoingTrusted_useIncomingSettingFalse_assertMDNMessageNotTrusted() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("UseOutgoingPolicyForIncomingNotifications", "false"));
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        String testMessage = TestUtils.readResource("MDNMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        Assertions.assertNotNull((Object)SMIMEenvMessage);
        agent = TestUtils.getStockAgent(Arrays.asList("Cerner.com"));
        DefaultTrustAnchorResolver resolver = (DefaultTrustAnchorResolver)agent.getTrustAnchors();
        CertificateResolver mockResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        DefaultTrustAnchorResolver newResolver = new DefaultTrustAnchorResolver(resolver.getOutgoingAnchors(), mockResolver);
        agent.setTrustAnchorResolver((TrustAnchorResolver)newResolver);
        IncomingMessage incomingMessage = null;
        try {
            incomingMessage = agent.processIncoming((MimeMessage)SMIMEenvMessage.getMessage());
        }
        catch (NHINDException e) {
            Assertions.assertEquals((Object)TrustError.NoTrustedRecipients, (Object)e.getError());
        }
        Assertions.assertNull((Object)incomingMessage);
    }

    @Test
    public void testIncomingDSN_incomingNotTrusted_outgoingTrusted_useIncomingSettingFalse_assertMDNMessageNotTrusted() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("UseOutgoingPolicyForIncomingNotifications", "false"));
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        String testMessage = TestUtils.readResource("DSNMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        Assertions.assertNotNull((Object)SMIMEenvMessage);
        agent = TestUtils.getStockAgent(Arrays.asList("Cerner.com"));
        DefaultTrustAnchorResolver resolver = (DefaultTrustAnchorResolver)agent.getTrustAnchors();
        CertificateResolver mockResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        DefaultTrustAnchorResolver newResolver = new DefaultTrustAnchorResolver(resolver.getOutgoingAnchors(), mockResolver);
        agent.setTrustAnchorResolver((TrustAnchorResolver)newResolver);
        IncomingMessage incomingMessage = null;
        try {
            incomingMessage = agent.processIncoming((MimeMessage)SMIMEenvMessage.getMessage());
        }
        catch (NHINDException e) {
            Assertions.assertEquals((Object)TrustError.NoTrustedRecipients, (Object)e.getError());
        }
        Assertions.assertNull((Object)incomingMessage);
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "trace");
    }
}

