/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.PKCS11Credential;
import org.nhindirect.common.crypto.impl.BootstrappedPKCS11Credential;
import org.nhindirect.common.crypto.impl.StaticPKCS11TokenKeyStoreProtectionManager;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.impl.CacheableKeyStoreManagerCertificateStore;
import org.nhindirect.stagent.utils.TestUtils;

public abstract class BaseKeyStoreManagerCertStoreTest {
    protected CacheableKeyStoreManagerCertificateStore store = null;

    @BeforeEach
    public void setUp() throws Exception {
        CertCacheFactory.getInstance().flushAll();
        if (!StringUtils.isEmpty((CharSequence)TestUtils.setupSafeNetToken())) {
            BootstrappedPKCS11Credential cred = new BootstrappedPKCS11Credential("1Kingpuff");
            StaticPKCS11TokenKeyStoreProtectionManager mgr = new StaticPKCS11TokenKeyStoreProtectionManager((PKCS11Credential)cred, "", "");
            this.store = new CacheableKeyStoreManagerCertificateStore((KeyStoreProtectionManager)mgr);
            this.store.remove(this.store.getAllCertificates());
            Assertions.assertTrue((boolean)this.store.getAllCertificates().isEmpty());
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.store != null) {
            this.store.remove(this.store.getAllCertificates());
            Assertions.assertTrue((boolean)this.store.getAllCertificates().isEmpty());
        }
    }
}

