/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.util.UUID;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.stagent.cert.impl.CRLRevocationManager;

public class CRLRevocationManager_initCRLCacheLocationTest {
    static final char[] invalidFileName = new char[65535];

    @BeforeEach
    public void setUp() {
        CryptoExtensions.registerJCEProviders();
        CRLRevocationManager.initCRLCacheLocation();
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.crlCacheLocation = null;
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("CRL_CACHE_LOCATION", ""));
    }

    @AfterEach
    public void tearDown() {
        CRLRevocationManager.getInstance().flush();
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("CRL_CACHE_LOCATION", ""));
        CRLRevocationManager.initCRLCacheLocation();
    }

    @Test
    public void testInitCRLCacheLocation_noOptionParameter() {
        CRLRevocationManager.initCRLCacheLocation();
        Assertions.assertTrue((boolean)CRLRevocationManager.crlCacheLocation.getAbsolutePath().endsWith("CrlCache"));
    }

    @Test
    public void testInitCRLCacheLocation_customOptionParameter() {
        String crlLocation = UUID.randomUUID().toString();
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("CRL_CACHE_LOCATION", "target/" + crlLocation));
        CRLRevocationManager.initCRLCacheLocation();
        Assertions.assertTrue((boolean)CRLRevocationManager.crlCacheLocation.getAbsolutePath().endsWith(crlLocation));
    }

    @Test
    public void testInitCRLCacheLocation_locExistsAndNotADirectory() throws Exception {
        String crlLocation = UUID.randomUUID().toString();
        File createFile = new File("target/" + crlLocation);
        createFile.createNewFile();
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("CRL_CACHE_LOCATION", "target/" + crlLocation));
        CRLRevocationManager.initCRLCacheLocation();
        Assertions.assertNull((Object)CRLRevocationManager.crlCacheLocation);
    }

    @Test
    public void testInitCRLCacheLocation_invalidLocationName() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("CRL_CACHE_LOCATION", "target/" + new String(invalidFileName)));
        CRLRevocationManager.initCRLCacheLocation();
        Assertions.assertNull((Object)CRLRevocationManager.crlCacheLocation);
    }

    static {
        for (int i = 1; i < 65535; i = (int)((char)(i + 1))) {
            CRLRevocationManager_initCRLCacheLocationTest.invalidFileName[i - 1] = i;
        }
    }
}

