/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.impl.BootstrappedKeyStoreProtectionManager;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.BaseKeyStoreManagerCertStoreTest;
import org.nhindirect.stagent.utils.TestUtils;

public class CacheableKeyStoreManagerCertificateStore_addTest
extends BaseKeyStoreManagerCertStoreTest {
    @Test
    public void testAdd_addNewCert_assertAdded() throws Exception {
        if (this.store != null) {
            X509CertificateEx user1 = TestUtils.getInternalCert("user1");
            this.store.add((X509Certificate)user1);
            Collection retrievedCerts = this.store.getAllCertificates();
            Assertions.assertEquals((int)1, (int)retrievedCerts.size());
            X509Certificate retrievedCert = (X509Certificate)retrievedCerts.iterator().next();
            Assertions.assertTrue((boolean)(retrievedCert instanceof X509CertificateEx));
            Assertions.assertEquals((Object)user1, (Object)retrievedCert);
        }
    }

    @Test
    public void testAdd_nonMutableStore_assertException() throws Exception {
        if (this.store != null) {
            BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
            this.store.setKeyStoreManager((KeyStoreProtectionManager)mgr);
            boolean exceptionOccured = false;
            try {
                X509CertificateEx user1 = TestUtils.getInternalCert("user1");
                this.store.add((X509Certificate)user1);
            }
            catch (IllegalStateException ex) {
                exceptionOccured = true;
            }
            Assertions.assertTrue((boolean)exceptionOccured);
        }
    }

    @Test
    public void testAdd_nonPrivateKeyCert_assertException() throws Exception {
        if (this.store != null) {
            boolean exceptionOccured = false;
            try {
                X509Certificate caCert = TestUtils.getExternalCert("cacert");
                this.store.add(caCert);
            }
            catch (IllegalArgumentException ex) {
                exceptionOccured = true;
            }
            Assertions.assertTrue((boolean)exceptionOccured);
        }
    }
}

