/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.impl.BootstrappedKeyStoreProtectionManager;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.DefaultCertStoreCachePolicy;
import org.nhindirect.stagent.cert.impl.CacheableKeyStoreManagerCertificateStore;

public class CacheableKeyStoreManagerCertificateStore_constructTest {
    @BeforeEach
    public void setUp() {
        CertCacheFactory.getInstance().flushAll();
    }

    @AfterEach
    public void tearDown() {
        CertCacheFactory.getInstance().flushAll();
    }

    @Test
    public void testContrust_defaultConstructor_assertNullStore() throws Exception {
        CacheableKeyStoreManagerCertificateStore store = new CacheableKeyStoreManagerCertificateStore();
        Assertions.assertNull((Object)store.storeMgr);
        Assertions.assertNotNull((Object)store.cachePolicy);
        Assertions.assertEquals((int)1000, (int)store.cachePolicy.getMaxItems());
        Assertions.assertEquals((int)3600, (int)store.cachePolicy.getSubjectTTL());
    }

    @Test
    public void testContrust_providedStore_assertNonEmptyStore() throws Exception {
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
        CacheableKeyStoreManagerCertificateStore store = new CacheableKeyStoreManagerCertificateStore((KeyStoreProtectionManager)mgr);
        Assertions.assertNotNull((Object)store.storeMgr);
        Assertions.assertNotNull((Object)store.cachePolicy);
        Assertions.assertEquals((int)1000, (int)store.cachePolicy.getMaxItems());
        Assertions.assertEquals((int)3600, (int)store.cachePolicy.getSubjectTTL());
    }

    @Test
    public void testContrust_providedStoreAndCachePolicy_assertNonEmptyStoreAndCustomPolicy() throws Exception {
        DefaultCertStoreCachePolicy policy = new DefaultCertStoreCachePolicy();
        policy.setMaxItems(456);
        policy.setSubjectTTL(999);
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
        CacheableKeyStoreManagerCertificateStore store = new CacheableKeyStoreManagerCertificateStore((KeyStoreProtectionManager)mgr, (CertStoreCachePolicy)policy);
        Assertions.assertNotNull((Object)store.storeMgr);
        Assertions.assertNotNull((Object)store.cachePolicy);
        Assertions.assertEquals((int)456, (int)store.cachePolicy.getMaxItems());
        Assertions.assertEquals((int)999, (int)store.cachePolicy.getSubjectTTL());
    }
}

