/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.BaseKeyStoreManagerCertStoreTest;
import org.nhindirect.stagent.utils.TestUtils;

public class CacheableKeyStoreManagerCertificateStore_getAllCertificateTest
extends BaseKeyStoreManagerCertStoreTest {
    @Test
    public void testGetGetAllCertificates_noCertificatesInstalled_assertNoCertificates() throws Exception {
        if (this.store != null) {
            Assertions.assertTrue((boolean)this.store.getAllCertificates().isEmpty());
        }
    }

    @Test
    public void testGetGetAllCertificates_singleCertificatesInstalled_assertCertificateRetrieved() throws Exception {
        if (this.store != null) {
            X509CertificateEx user1 = TestUtils.getInternalCert("user1");
            this.store.add((X509Certificate)user1);
            Collection retrievedCerts = this.store.getAllCertificates();
            Assertions.assertEquals((int)1, (int)retrievedCerts.size());
            X509Certificate retrievedCert = (X509Certificate)retrievedCerts.iterator().next();
            Assertions.assertTrue((boolean)(retrievedCert instanceof X509CertificateEx));
            Assertions.assertEquals((Object)user1, (Object)retrievedCert);
        }
    }
}

