/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.impl.DNSCertificateStore;
import org.xbill.DNS.ResolverConfig;

public class DNSCertificateStore_constructTest {
    @BeforeEach
    public void setUp() {
        CertCacheFactory.getInstance().flushAll();
    }

    @AfterEach
    public void tearDown() {
        CertCacheFactory.getInstance().flushAll();
    }

    @Test
    public void testContructDNSCertificateStore_defaultConstructor() {
        DNSCertificateStore store = new DNSCertificateStore();
        Assertions.assertEquals((int)ResolverConfig.getCurrentConfig().servers().size(), (int)store.servers.size());
        Assertions.assertNull((Object)store.localStoreDelegate);
        Assertions.assertNotNull((Object)store.cachePolicy);
    }

    @Test
    public void testContructDNSCertificateStore_nullServers() {
        DNSCertificateStore store = new DNSCertificateStore(null);
        Assertions.assertEquals((int)ResolverConfig.getCurrentConfig().servers().size(), (int)store.servers.size());
        Assertions.assertNull((Object)store.localStoreDelegate);
        Assertions.assertNotNull((Object)store.cachePolicy);
    }

    @Test
    public void testContructDNSCertificateStore_emptyServers() {
        DNSCertificateStore store = new DNSCertificateStore(new ArrayList());
        Assertions.assertEquals((int)ResolverConfig.getCurrentConfig().servers().size(), (int)store.servers.size());
        Assertions.assertNull((Object)store.localStoreDelegate);
        Assertions.assertNotNull((Object)store.cachePolicy);
    }

    @Test
    public void testContructDNSCertificateStore_providedServers() {
        List<String> servers = Arrays.asList("159.140.168.3");
        DNSCertificateStore store = new DNSCertificateStore(servers);
        Assertions.assertEquals((int)1, (int)store.servers.size());
        Assertions.assertEquals((Object)"159.140.168.3", store.servers.iterator().next());
        Assertions.assertNull((Object)store.localStoreDelegate);
        Assertions.assertNotNull((Object)store.cachePolicy);
    }

    @Test
    public void testContructDNSCertificateStore_fullConstructor_nullBootStrap() {
        DNSCertificateStore store = new DNSCertificateStore(null, null, null);
        Assertions.assertNotNull((Object)store.cachePolicy);
        Assertions.assertNull((Object)store.localStoreDelegate);
    }

    @Test
    public void testContructDNSCertificateStore_fullConstructor_providedServers() {
        CertificateStore bootStrap = (CertificateStore)Mockito.mock(CertificateStore.class);
        List<String> servers = Arrays.asList("159.140.168.3");
        DNSCertificateStore store = new DNSCertificateStore(servers, bootStrap, null);
        Assertions.assertEquals((int)1, (int)store.servers.size());
        Assertions.assertEquals((Object)"159.140.168.3", store.servers.iterator().next());
        Assertions.assertEquals((Object)bootStrap, (Object)store.localStoreDelegate);
        Assertions.assertNotNull((Object)store.cachePolicy);
    }

    @Test
    public void testContructDNSCertificateStore_fullConstructor_nullServers() {
        CertificateStore bootStrap = (CertificateStore)Mockito.mock(CertificateStore.class);
        DNSCertificateStore store = new DNSCertificateStore(null, bootStrap, null);
        Assertions.assertEquals((int)ResolverConfig.getCurrentConfig().servers().size(), (int)store.servers.size());
        Assertions.assertNotNull((Object)store.localStoreDelegate);
        Assertions.assertNotNull((Object)store.cachePolicy);
    }

    @Test
    public void testContructDNSCertificateStore_fullConstructor_emptyServers() {
        CertificateStore bootStrap = (CertificateStore)Mockito.mock(CertificateStore.class);
        DNSCertificateStore store = new DNSCertificateStore(new ArrayList(), bootStrap, null);
        Assertions.assertEquals((int)ResolverConfig.getCurrentConfig().servers().size(), (int)store.servers.size());
        Assertions.assertNotNull((Object)store.localStoreDelegate);
        Assertions.assertNotNull((Object)store.cachePolicy);
    }

    @Test
    public void testContructDNSCertificateStore_fullConstructor_emptyServersAndProvidedCachePolicy() {
        CertificateStore bootStrap = (CertificateStore)Mockito.mock(CertificateStore.class);
        CertStoreCachePolicy cachePolicy = (CertStoreCachePolicy)Mockito.mock(CertStoreCachePolicy.class);
        DNSCertificateStore store = new DNSCertificateStore(new ArrayList(), bootStrap, cachePolicy);
        Assertions.assertEquals((int)ResolverConfig.getCurrentConfig().servers().size(), (int)store.servers.size());
        Assertions.assertNotNull((Object)store.localStoreDelegate);
        Assertions.assertEquals((Object)cachePolicy, (Object)store.cachePolicy);
    }
}

