/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.options.OptionsManagerUtils;
import org.nhindirect.stagent.cert.impl.DNSCertificateStore;
import org.xbill.DNS.ResolverConfig;

public class DNSCertificateStore_getServerQuerySettingsTest {
    @BeforeEach
    public void setUp() {
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    @AfterEach
    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerOptions();
    }

    @Test
    public void testGetServerQuerySettingsTest_useDefaultSettings_assertSettings() {
        DNSCertificateStore service = new DNSCertificateStore();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)service.retries);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)service.timeout);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)service.useTCP);
        List configedServers = ResolverConfig.getCurrentConfig().servers().stream().map(addr -> addr.getHostString()).collect(Collectors.toList());
        Assertions.assertThat(configedServers).hasSameElementsAs((Iterable)service.servers);
    }

    @Test
    public void testGetServerQuerySettingsTest_useSettingsFromJVMParams_assertSettings() {
        System.setProperty("org.nhindirect.stagent.cert.dnsresolver.Servers", "10.3.4.3,google.lookup.com");
        System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerRetries", "1");
        System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerTimeout", "5");
        System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerUseTCP", "false");
        try {
            DNSCertificateStore service = new DNSCertificateStore();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)service.retries);
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)service.timeout);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)service.useTCP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)Arrays.equals(new String[]{"10.3.4.3", "google.lookup.com"}, service.servers.toArray()));
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.Servers", "");
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerRetries", "");
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerTimeout", "");
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerUseTCP", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetServerQuerySettingsTest_useSettingsFromPropertiesFile_assertSettings() throws Exception {
        File propFile = new File("./target/props/agentSettings.properties");
        if (propFile.exists()) {
            propFile.delete();
        }
        System.setProperty("org.nhindirect.stagent.PropertiesFile", "./target/props/agentSettings.properties");
        try (FileOutputStream outStream = FileUtils.openOutputStream((File)propFile);){
            ((OutputStream)outStream).write("org.nhindirect.stagent.cert.dnsresolver.Servers=10.3.4.3,google.lookup.com\r\n".getBytes());
            ((OutputStream)outStream).write("org.nhindirect.stagent.cert.dnsresolver.ServerRetries=5\r\n".getBytes());
            ((OutputStream)outStream).write("org.nhindirect.stagent.cert.dnsresolver.ServerTimeout=7\r\n".getBytes());
            ((OutputStream)outStream).write("org.nhindirect.stagent.cert.dnsresolver.ServerUseTCP=false\r\n".getBytes());
            outStream.flush();
        }
        try {
            DNSCertificateStore service = new DNSCertificateStore();
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)service.retries);
            org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)service.timeout);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)service.useTCP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)Arrays.equals(new String[]{"10.3.4.3", "google.lookup.com"}, service.servers.toArray()));
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.Servers", "");
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerRetries", "");
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerTimeout", "");
            System.setProperty("org.nhindirect.stagent.cert.dnsresolver.ServerUseTCP", "");
            System.setProperty("org.nhindirect.stagent.PropertiesFile", "");
            propFile.delete();
        }
    }
}

