/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.mail.BodyPart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.mail.smime.CMSProcessableBodyPart;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.common.options.OptionsManagerUtils;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cryptography.CryptoAlgorithmsHelper;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.utils.TestUtils;

public class SMIMECryptographerImpl_createSignatureEntityTest {
    protected String pkcs11ProvName;

    @BeforeEach
    public void setUp() throws Exception {
        OptionsManagerUtils.clearOptionsManagerOptions();
        OptionsManagerUtils.clearOptionsManagerInstance();
        CryptoExtensions.registerJCEProviders();
    }

    @Test
    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerOptions();
        OptionsManagerUtils.clearOptionsManagerInstance();
        CryptoExtensions.registerJCEProviders();
    }

    protected MimeEntity contentToMimeEntity(BodyPart part) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        part.writeTo((OutputStream)bos);
        bos.flush();
        ByteArrayInputStream stream = new ByteArrayInputStream(bos.toByteArray());
        return new MimeEntity((InputStream)stream);
    }

    @Test
    public void testCreateSignatureEntity_defaultSigGenerator_assertEntityCreated() throws Exception {
        SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        MimeEntity ent = new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes())).extractEntityForSignature(true);
        byte[] bytesToSign = EntitySerializer.Default.serializeToBytes((MimePart)ent);
        X509Certificate sigCertBPrivate = TestUtils.loadCertificate("certCheckB.p12");
        MimeMultipart mm = impl.createSignatureEntity(bytesToSign, Arrays.asList(sigCertBPrivate));
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        this.validatedSignatureHeaders(mm);
        this.validateSignature(this.deserializeSignatureEnvelope(mm), sigCertBPrivate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSignatureEntity_hsmSignatureGenerator_assertEntityCreatedAndMatchesControl() throws Exception {
        String installedAlias = "JunitTestKey";
        this.pkcs11ProvName = TestUtils.setupSafeNetToken();
        if (!StringUtils.isEmpty((CharSequence)this.pkcs11ProvName)) {
            KeyStore ks = KeyStore.getInstance("PKCS11");
            ks.load(null, "1Kingpuff".toCharArray());
            try {
                ks.deleteEntry("JunitTestKey");
            }
            catch (Exception exception) {
                // empty catch block
            }
            X509CertificateEx sigCertBPrivate = (X509CertificateEx)TestUtils.loadCertificate("certCheckB.p12");
            try {
                ks.setKeyEntry("JunitTestKey", sigCertBPrivate.getPrivateKey(), null, new Certificate[]{sigCertBPrivate});
                KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)ks.getEntry("JunitTestKey", null);
                X509CertificateEx signerCert = X509CertificateEx.fromX509Certificate((X509Certificate)((X509Certificate)entry.getCertificate()), (PrivateKey)entry.getPrivateKey());
                CryptoExtensions.setJCEProviderName((String)this.pkcs11ProvName);
                SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
                String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
                MimeEntity ent = new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes())).extractEntityForSignature(true);
                byte[] bytesToSign = EntitySerializer.Default.serializeToBytes((MimePart)ent);
                MimeMultipart mm = impl.createSignatureEntity(bytesToSign, Arrays.asList(signerCert));
                Assertions.assertNotNull((Object)mm);
                Assertions.assertEquals((int)2, (int)mm.getCount());
                this.validatedSignatureHeaders(mm);
                SMIMECryptographerImpl controllImpl = new SMIMECryptographerImpl();
                MimeMultipart controllmm = controllImpl.createSignatureEntity(bytesToSign, Arrays.asList(sigCertBPrivate));
                Assertions.assertNotNull((Object)controllmm);
                Assertions.assertEquals((int)2, (int)controllmm.getCount());
                this.validateSignature(this.deserializeSignatureEnvelope(mm), (X509Certificate)sigCertBPrivate);
                this.validateSignature(this.deserializeSignatureEnvelope(controllmm), (X509Certificate)sigCertBPrivate);
            }
            finally {
                ks.deleteEntry("JunitTestKey");
            }
        }
    }

    protected void validateSignature(CMSSignedData data, X509Certificate signerCert) throws Exception {
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((int)1, (int)data.getSignerInfos().getSigners().size());
        for (SignerInformation sigInfo : data.getSignerInfos().getSigners()) {
            Assertions.assertTrue((boolean)sigInfo.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(CryptoExtensions.getJCEProviderName()).build(signerCert)));
            Assertions.assertEquals((Object)DigestAlgorithm.SHA256.getOID(), (Object)sigInfo.getDigestAlgOID());
        }
    }

    protected void validatedSignatureHeaders(MimeMultipart mm) throws Exception {
        ContentType type = new ContentType(mm.getContentType());
        Assertions.assertTrue((boolean)type.match("multipart/signed"));
        Assertions.assertEquals((Object)"application/pkcs7-signature", (Object)type.getParameter("protocol"));
        Assertions.assertEquals((Object)CryptoAlgorithmsHelper.toDigestAlgorithmMicalg((DigestAlgorithm)DigestAlgorithm.SHA256), (Object)type.getParameter("micalg"));
        ContentType signedTypetype = new ContentType(mm.getBodyPart(1).getContentType());
        Assertions.assertTrue((boolean)signedTypetype.match("application/pkcs7-signature"));
    }

    protected CMSSignedData deserializeSignatureEnvelope(MimeMultipart mm) throws Exception {
        MimeEntity contentEntity = this.contentToMimeEntity(mm.getBodyPart(0));
        byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)contentEntity);
        MimeBodyPart signedContent = null;
        signedContent = new MimeBodyPart((InputStream)new ByteArrayInputStream(messageBytes));
        return new CMSSignedData((CMSProcessable)new CMSProcessableBodyPart((BodyPart)signedContent), mm.getBodyPart(1).getInputStream());
    }
}

