/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;

public class SMIMECryptographerImpl_isAllowedDigestAlgorithmTest {
    protected SMIMECryptographerImpl impl;

    @BeforeEach
    public void setUp() {
        this.impl = new SMIMECryptographerImpl();
    }

    @Test
    public void testIsAllowedDigestAlgorithm_SHA256_assertAllowed() throws Exception {
        Assertions.assertTrue((boolean)this.impl.isAllowedDigestAlgorithm(DigestAlgorithm.SHA256.getOID()));
    }

    @Test
    public void testIsAllowedDigestAlgorithm_SHA384_assertAllowed() throws Exception {
        Assertions.assertTrue((boolean)this.impl.isAllowedDigestAlgorithm(DigestAlgorithm.SHA384.getOID()));
    }

    @Test
    public void testIsAllowedDigestAlgorithm_MD5_assertNotAllowed() throws Exception {
        Assertions.assertFalse((boolean)this.impl.isAllowedDigestAlgorithm(DigestAlgorithm.MD5.getOID()));
    }

    @Test
    public void testIsAllowedDigestAlgorithm_SHA1_assertNotAllowed() throws Exception {
        Assertions.assertFalse((boolean)this.impl.isAllowedDigestAlgorithm(DigestAlgorithm.SHA1.getOID()));
    }

    @Test
    public void testIsAllowedDigestAlgorithm_SHA1WITHRSA_assertNotAllowed() throws Exception {
        Assertions.assertFalse((boolean)this.impl.isAllowedDigestAlgorithm(DigestAlgorithm.SHA1WITHRSA.getOID()));
    }
}

