/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.policy.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.stagent.policy.impl.UniversalPolicyResolver;

public class UniversalPolicyResolver_constructTest {
    @Test
    public void testConstruct_singleExpression_assertAttributes() {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        UniversalPolicyResolver resolver = new UniversalPolicyResolver(expression);
        Assertions.assertNotNull((Object)resolver);
        Assertions.assertEquals((int)1, (int)resolver.expressions.size());
        Assertions.assertEquals((Object)expression, resolver.expressions.iterator().next());
    }

    @Test
    public void testConstruct_multipleExpressions_assertAttributes() {
        PolicyExpression expression1 = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        PolicyExpression expression2 = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        UniversalPolicyResolver resolver = new UniversalPolicyResolver(Arrays.asList(expression1, expression2));
        Assertions.assertNotNull((Object)resolver);
        Assertions.assertEquals((int)2, (int)resolver.expressions.size());
        Iterator iter = resolver.expressions.iterator();
        Assertions.assertEquals((Object)expression1, iter.next());
        Assertions.assertEquals((Object)expression2, iter.next());
    }

    @Test
    public void testConstruct_emptyExpression_assertException() {
        boolean exceptionOccured = false;
        try {
            new UniversalPolicyResolver(new ArrayList());
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstruct_nullExpression_assertException() {
        boolean exceptionOccured = false;
        try {
            new UniversalPolicyResolver((PolicyExpression)null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            new UniversalPolicyResolver((Collection)null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

