/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.io.File;
import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.trust.TrustChainValidator;
import org.nhindirect.stagent.utils.TestUtils;

public class TrustChainValidator_downloadCertFromAIATest {
    protected String filePrefix;

    @BeforeEach
    public void setUp() {
        File file = new File("./src/test/resources/certs/bob.der");
        this.filePrefix = file.getAbsolutePath().contains(":/") ? "file:///" : "file:///";
    }

    @Test
    public void testDownloadCertFromAIA_validURL_assertDownloaded() throws Exception {
        TrustChainValidator validator = new TrustChainValidator();
        File fl = new File("src/test/resources/certs/bob.der");
        X509Certificate downloadedCert = validator.downloadCertFromAIA(this.filePrefix + fl.getAbsolutePath());
        Assertions.assertNotNull((Object)downloadedCert);
        Assertions.assertEquals((Object)TestUtils.loadCertificate("bob.der"), (Object)downloadedCert);
    }

    @Test
    public void testDownloadCertFromAIA_certNotAtURL_assertException() throws Exception {
        TrustChainValidator validator = new TrustChainValidator();
        File fl = new File("src/test/resources/certs/bob.derdd");
        boolean exceptionOccurred = false;
        try {
            validator.downloadCertFromAIA(this.filePrefix + fl.getAbsolutePath());
        }
        catch (NHINDException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
    }
}

