/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.trust.TrustChainValidator;
import org.nhindirect.stagent.utils.TestUtils;

public class TrustChainValidator_downloadCertsFromAIATest {
    protected String filePrefix;

    @BeforeEach
    public void setUp() {
        File file = new File("./src/test/resources/certs/bob.der");
        this.filePrefix = file.getAbsolutePath().contains(":/") ? "file:///" : "file:///";
    }

    @Test
    public void testDownloadCertsFromAIA_validURL_singleCert_assertDownloaded() throws Exception {
        TrustChainValidator validator = new TrustChainValidator();
        File fl = new File("src/test/resources/certs/bob.der");
        X509Certificate downloadedCert = (X509Certificate)validator.downloadCertsFromAIA(this.filePrefix + fl.getAbsolutePath()).iterator().next();
        Assertions.assertNotNull((Object)downloadedCert);
        Assertions.assertEquals((Object)TestUtils.loadCertificate("bob.der"), (Object)downloadedCert);
    }

    @Test
    public void testDownloadCertsFromAIA_validURL_collectionCert_assertDownloaded() throws Exception {
        TrustChainValidator validator = new TrustChainValidator();
        File fl = new File("src/test/resources/certs/cmsRandomizer.p7b");
        Collection downloadedCerts = validator.downloadCertsFromAIA(this.filePrefix + fl.getAbsolutePath());
        Assertions.assertNotNull((Object)downloadedCerts);
        Assertions.assertEquals((int)6, (int)downloadedCerts.size());
    }

    @Test
    public void testDownloadCertsFromAIA_certNotAtURL_assertException() throws Exception {
        TrustChainValidator validator = new TrustChainValidator();
        File fl = new File("src/test/resources/certs/bob.derdd");
        boolean exceptionOccurred = false;
        try {
            validator.downloadCertsFromAIA(this.filePrefix + fl.getAbsolutePath());
        }
        catch (NHINDException e) {
            exceptionOccurred = true;
        }
        Assertions.assertTrue((boolean)exceptionOccurred);
    }
}

