/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.trust.TrustChainValidator;
import org.nhindirect.stagent.utils.TestUtils;

public class TrustChainValidator_getIntermediateCertsByAIATest {
    @Test
    public void testGetIntermediateCertsByAIA_AIAExists_validateResolved() throws Exception {
        TrustChainValidatorWrapper validator = new TrustChainValidatorWrapper(){

            protected Collection<X509Certificate> downloadCertsFromAIA(String url) throws NHINDException {
                try {
                    this.retrievedURL = url;
                    return Arrays.asList(TestUtils.loadCertificate("bob.der"));
                }
                catch (Exception e) {
                    throw new NHINDException((Object)e);
                }
            }
        };
        TrustChainValidatorWrapper spyValidator = (TrustChainValidatorWrapper)((Object)Mockito.spy((Object)((Object)validator)));
        Collection downloadedCerts = spyValidator.getIntermediateCertsByAIA(TestUtils.loadCertificate("demo.sandboxcernerdirect.com.der"));
        Assertions.assertEquals((Object)"http://sandboxcernerdirect.com/professional/public/subordinate.der", (Object)spyValidator.retrievedURL);
        Assertions.assertEquals((int)1, (int)downloadedCerts.size());
        Assertions.assertEquals((Object)TestUtils.loadCertificate("bob.der"), downloadedCerts.iterator().next());
        ((TrustChainValidatorWrapper)((Object)Mockito.verify((Object)((Object)spyValidator), (VerificationMode)Mockito.times((int)1)))).downloadCertsFromAIA((String)ArgumentMatchers.any());
    }

    @Test
    public void testGetIntermediateCertsByAIA_emptyAIA_validateNotResolved() throws Exception {
        TrustChainValidatorWrapper validator = new TrustChainValidatorWrapper(){

            protected Collection<X509Certificate> downloadCertsFromAIA(String url) throws NHINDException {
                try {
                    this.retrievedURL = url;
                    return Arrays.asList(TestUtils.loadCertificate("bob.der"));
                }
                catch (Exception e) {
                    throw new NHINDException((Object)e);
                }
            }
        };
        TrustChainValidatorWrapper spyValidator = (TrustChainValidatorWrapper)((Object)Mockito.spy((Object)((Object)validator)));
        Collection downloadedCerts = spyValidator.getIntermediateCertsByAIA(TestUtils.loadCertificate("altNameOnly.der"));
        Assertions.assertNull((Object)spyValidator.retrievedURL);
        Assertions.assertEquals((int)0, (int)downloadedCerts.size());
        ((TrustChainValidatorWrapper)((Object)Mockito.verify((Object)((Object)spyValidator), (VerificationMode)Mockito.never()))).downloadCertsFromAIA((String)ArgumentMatchers.any());
    }

    @Test
    public void testGetIntermediateCertsByAIA_errorInDownload_validateEmpty() throws Exception {
        TrustChainValidatorWrapper validator = new TrustChainValidatorWrapper(){

            protected Collection<X509Certificate> downloadCertsFromAIA(String url) throws NHINDException {
                throw new NHINDException();
            }
        };
        TrustChainValidatorWrapper spyValidator = (TrustChainValidatorWrapper)((Object)Mockito.spy((Object)((Object)validator)));
        Collection downloadedCerts = spyValidator.getIntermediateCertsByAIA(TestUtils.loadCertificate("demo.sandboxcernerdirect.com.der"));
        Assertions.assertNull((Object)spyValidator.retrievedURL);
        Assertions.assertEquals((int)0, (int)downloadedCerts.size());
        ((TrustChainValidatorWrapper)((Object)Mockito.verify((Object)((Object)spyValidator), (VerificationMode)Mockito.times((int)1)))).downloadCertsFromAIA((String)ArgumentMatchers.any());
    }

    static class TrustChainValidatorWrapper
    extends TrustChainValidator {
        public String retrievedURL;

        TrustChainValidatorWrapper() {
        }
    }
}

