/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.stagent.cert.CacheableCertStore;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.impl.AbstractKeyStoreManagerCertificateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheableKeyStoreManagerCertificateStore
extends AbstractKeyStoreManagerCertificateStore
implements CacheableCertStore {
    private static final Logger log = LoggerFactory.getLogger(CacheableKeyStoreManagerCertificateStore.class);
    private static final String CACHE_NAME = "CACHEABLE_PKCS11_STORE_CERT_CACHE";
    protected static final int DEFAULT_MAX_CAHCE_ITEMS = 1000;
    protected static final int DEFAULT_CACHE_TTL = 3600;
    protected JCS cache;
    protected CertStoreCachePolicy cachePolicy;

    public CacheableKeyStoreManagerCertificateStore() {
        this(null, null);
    }

    public CacheableKeyStoreManagerCertificateStore(KeyStoreProtectionManager storeMgr) {
        this(storeMgr, null);
    }

    public CacheableKeyStoreManagerCertificateStore(KeyStoreProtectionManager storeMgr, CertStoreCachePolicy cachePolicy) {
        super(storeMgr);
        this.cachePolicy = cachePolicy;
        this.createCache();
    }

    @Override
    public void setCachePolicy(CertStoreCachePolicy policy) {
        this.cachePolicy = policy;
        this.applyCachePolicy(policy);
    }

    private void applyCachePolicy(CertStoreCachePolicy policy) {
        if (this.getCache() != null) {
            try {
                ICompositeCacheAttributes attributes = this.cache.getCacheAttributes();
                attributes.setMaxObjects(policy.getMaxItems());
                attributes.setUseLateral(false);
                attributes.setUseRemote(false);
                this.cache.setCacheAttributes(attributes);
                IElementAttributes eattributes = this.cache.getDefaultElementAttributes();
                eattributes.setMaxLifeSeconds((long)policy.getSubjectTTL());
                eattributes.setIsEternal(false);
                eattributes.setIsLateral(false);
                eattributes.setIsRemote(false);
                this.cache.setDefaultElementAttributes(eattributes);
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    private synchronized JCS getCache() {
        if (this.cache == null) {
            this.createCache();
        }
        return this.cache;
    }

    private void createCache() {
        try {
            this.cache = CertCacheFactory.getInstance().getCertCache(CACHE_NAME, this.cachePolicy == null ? this.getDefaultPolicy() : this.cachePolicy);
            if (this.cachePolicy == null) {
                this.cachePolicy = this.getDefaultPolicy();
            }
        }
        catch (CacheException e) {
            log.warn("CacheablePKCS11CertificateStore - Could not create certificate cache {}", (Object)CACHE_NAME, (Object)e);
        }
    }

    @Override
    public void flush(boolean purgeBootStrap) {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    @Override
    public Collection<X509Certificate> getCertificates(String subjectName) {
        Collection<X509Certificate> retVal;
        int index = subjectName.indexOf("EMAILADDRESS=");
        String realSubjectName = index > -1 ? subjectName.substring(index + "EMAILADDRESS=".length()) : subjectName;
        JCS cache = this.getCache();
        if (cache != null) {
            retVal = (Collection<X509Certificate>)cache.get((Object)realSubjectName);
            if (retVal == null || retVal.size() == 0) {
                retVal = super.getCertificates(subjectName);
            }
        } else {
            retVal = super.getCertificates(subjectName);
        }
        if (retVal == null || retVal.size() == 0) {
            log.info("getCertificates(String subjectName) - Could not find a PKCS11 certificate for subject {}", (Object)subjectName);
        } else {
            try {
                if (cache != null) {
                    cache.put((Object)realSubjectName, retVal);
                }
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
        return retVal;
    }

    @Override
    public void setBootStrap(CertificateStore bootstrapStore) {
    }

    @Override
    public void loadBootStrap() {
    }

    @Override
    public void loadBootStrap(CertificateStore bootstrapStore) {
    }

    private CertStoreCachePolicy getDefaultPolicy() {
        return new DefaultGenericPKCS11CachePolicy();
    }

    private static class DefaultGenericPKCS11CachePolicy
    implements CertStoreCachePolicy {
        protected final int maxItems;
        protected final int subjectTTL;

        public DefaultGenericPKCS11CachePolicy() {
            OptionsParameter param = OptionsManager.getInstance().getParameter("CACHABLE_PKCS11_CERT_RESOLVER_MAX_CACHE_SIZE");
            this.maxItems = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)1000);
            param = OptionsManager.getInstance().getParameter("CACHABLE_PKCS11_CERT_RESOLVER_CACHE_TTL");
            this.subjectTTL = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)3600);
        }

        @Override
        public int getMaxItems() {
            return this.maxItems;
        }

        @Override
        public int getSubjectTTL() {
            return this.subjectTTL;
        }
    }
}

