/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.CacheableCertStore;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.CertificateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SimpleResolver;

public class DNSCertificateStore
extends CertificateStore
implements CacheableCertStore {
    private static final Logger log = LoggerFactory.getLogger(DNSCertificateStore.class);
    private static final String CACHE_NAME = "DNS_REMOTE_CERT_CACHE";
    protected static final int DEFAULT_DNS_TIMEOUT = 3;
    protected static final int DEFAULT_DNS_RETRIES = 2;
    protected static final boolean DEFAULT_DNS_USE_TCP = true;
    protected static final int DEFAULT_DNS_MAX_CAHCE_ITEMS = 1000;
    protected static final int DEFAULT_DNS_TTL = 3600;
    protected static final int DEFAULT_URL_CONNECTION_TIMEOUT = 10000;
    protected static final int DEFAULT_URL_READ_TIMEOUT = 10000;
    protected CertificateStore localStoreDelegate;
    protected List<String> servers = new ArrayList<String>();
    protected JCS cache;
    protected CertStoreCachePolicy cachePolicy;
    protected int timeout;
    protected int retries;
    protected boolean useTCP;

    public DNSCertificateStore() {
        this.getServerQuerySettings();
        this.setServers(null);
        this.createCache();
    }

    public DNSCertificateStore(Collection<String> servers) {
        this.getServerQuerySettings();
        this.setServers(servers);
        this.createCache();
    }

    public DNSCertificateStore(Collection<String> servers, CertificateStore bootstrapStore, CertStoreCachePolicy policy) {
        this.getServerQuerySettings();
        this.setServers(servers);
        this.cachePolicy = policy;
        this.localStoreDelegate = bootstrapStore;
        this.createCache();
        if (this.localStoreDelegate != null) {
            this.loadBootStrap();
        }
    }

    private void getServerQuerySettings() {
        OptionsParameter param = OptionsManager.getInstance().getParameter("DNS_CERT_RESOLVER_TIMEOUT");
        this.timeout = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)3);
        param = OptionsManager.getInstance().getParameter("DNS_CERT_RESOLVER_RETRIES");
        this.retries = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)2);
        param = OptionsManager.getInstance().getParameter("DNS_CERT_RESOLVER_USE_TCP");
        this.useTCP = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)true);
    }

    private synchronized JCS getCache() {
        if (this.cache == null) {
            this.createCache();
        }
        return this.cache;
    }

    private void createCache() {
        try {
            this.cache = CertCacheFactory.getInstance().getCertCache(CACHE_NAME, this.cachePolicy == null ? this.getDefaultPolicy() : this.cachePolicy);
            if (this.cachePolicy == null) {
                this.cachePolicy = this.getDefaultPolicy();
            }
        }
        catch (CacheException e) {
            log.warn("DNSCertificateStore - Could not create certificate cache {}", (Object)CACHE_NAME, (Object)e);
        }
    }

    private CertStoreCachePolicy getDefaultPolicy() {
        return new DefaultDNSCachePolicy();
    }

    public void setServers(Collection<String> servers) {
        if (servers == null || servers.size() == 0) {
            String[] configedServers = null;
            OptionsParameter serverOptions = OptionsManager.getInstance().getParameter("DNS_CERT_RESOLVER_SERVERS");
            if (serverOptions != null && !StringUtils.isEmpty((CharSequence)serverOptions.getParamValue())) {
                configedServers = serverOptions.getParamValue().split(",");
            } else {
                List<String> holdServer = ResolverConfig.getCurrentConfig().servers().stream().map(addr -> addr.getHostString()).collect(Collectors.toList());
                configedServers = holdServer.toArray(new String[holdServer.size()]);
            }
            if (configedServers != null) {
                this.servers.addAll(Arrays.asList(configedServers));
            }
        } else {
            this.servers.clear();
            this.servers.addAll(servers);
        }
    }

    @Override
    public boolean contains(X509Certificate cert) {
        return this.localStoreDelegate == null ? false : this.localStoreDelegate.contains(cert);
    }

    @Override
    public void add(X509Certificate cert) {
        if (this.localStoreDelegate != null) {
            this.localStoreDelegate.add(cert);
        }
    }

    @Override
    public void remove(X509Certificate cert) {
        if (this.localStoreDelegate != null) {
            this.localStoreDelegate.remove(cert);
        }
    }

    @Override
    public Collection<X509Certificate> getCertificates(String subjectName) {
        Collection<X509Certificate> retVal;
        int index = subjectName.indexOf("EMAILADDRESS=");
        String realSubjectName = index > -1 ? subjectName.substring(index + "EMAILADDRESS=".length()) : subjectName;
        JCS cache = this.getCache();
        if (cache != null) {
            retVal = (Collection<X509Certificate>)cache.get((Object)realSubjectName);
            if (!(retVal != null && retVal.size() != 0 || (retVal = this.lookupDNS(realSubjectName)) != null && retVal.size() != 0)) {
                log.info("getCertificates(String subjectName) - Could not find a DNS certificate for subject {}", (Object)subjectName);
            }
        } else {
            retVal = this.lookupDNS(realSubjectName);
            if (retVal.size() == 0) {
                if (this.localStoreDelegate != null) {
                    retVal = this.localStoreDelegate.getCertificates(realSubjectName);
                    if (retVal == null || retVal.size() == 0) {
                        log.info("getCertificates(String subjectName) - Could not find a DNS certificate for subject {}", (Object)subjectName);
                    }
                } else {
                    log.info("getCertificates(String subjectName) - Could not find a DNS certificate for subject {}", (Object)subjectName);
                }
            }
        }
        return retVal;
    }

    @Override
    public Collection<X509Certificate> getAllCertificates() {
        return this.localStoreDelegate == null ? null : this.localStoreDelegate.getAllCertificates();
    }

    /*
     * WARNING - void declaration
     */
    protected Collection<X509Certificate> lookupDNS(String name) {
        String lookupName = name.replace('@', '.');
        Collection<Object> retVal = new ArrayList();
        int index = name.indexOf("@");
        String domain = index > -1 ? name.substring(index + 1) : name;
        try {
            void var7_17;
            void var7_11;
            Lookup lu = new Lookup(new Name(lookupName), 37);
            lu.setResolver((Resolver)this.createExResolver(this.servers.toArray(new String[this.servers.size()]), this.retries, this.timeout));
            lu.setSearchPath((String[])null);
            Object var7_9 = null;
            try {
                Record[] recordArray = lu.run();
            }
            catch (Exception e) {
                log.warn("Error using recusive DNS CERT lookup for name {}\r\nFalling back to looking up NS record for a targeted search", (Object)lookupName, (Object)e);
            }
            if (var7_11 == null || ((void)var7_11).length == 0) {
                void var7_13;
                Name tempDomain;
                lu = new Lookup(new Name(lookupName), 5);
                lu.setResolver((Resolver)this.createExResolver(this.servers.toArray(new String[this.servers.size()]), this.retries, this.timeout));
                lu.setSearchPath((String[])null);
                Record[] recordArray = lu.run();
                if (recordArray != null && recordArray.length > 0) {
                    CNAMERecord cnameRect = (CNAMERecord)recordArray[0];
                    tempDomain = cnameRect.getTarget();
                } else {
                    tempDomain = new Name(domain);
                }
                while (tempDomain.labels() > 1) {
                    lu = new Lookup(tempDomain, 2);
                    lu.setResolver((Resolver)this.createExResolver(this.servers.toArray(new String[this.servers.size()]), this.retries, this.timeout));
                    lu.setSearchPath((String[])null);
                    Record[] recordArray2 = lu.run();
                    if (recordArray2 != null && recordArray2.length > 0) break;
                    tempDomain = new Name(tempDomain.toString().substring(tempDomain.toString().indexOf(".") + 1));
                }
                if (var7_13 == null || ((void)var7_13).length == 0) {
                    return retVal;
                }
                String[] remoteServers = new String[((void)var7_13).length];
                for (int i = 0; i < remoteServers.length - 0; ++i) {
                    remoteServers[i] = ((NSRecord)var7_13[i]).getTarget().toString();
                }
                lu = new Lookup(new Name(lookupName), 37);
                ExtendedResolver remoteResolver = this.createExResolver(remoteServers, 2, 3);
                if (remoteResolver.getResolvers().length > 0) {
                    lu.setResolver((Resolver)remoteResolver);
                    lu.setSearchPath((String[])null);
                    Record[] recordArray3 = lu.run();
                } else {
                    Object var7_16 = null;
                }
            }
            if (var7_17 != null) {
                retVal = new ArrayList();
                block12: for (void rec : var7_17) {
                    if (!(rec instanceof CERTRecord)) continue;
                    CERTRecord certRec = (CERTRecord)rec;
                    switch (certRec.getCertType()) {
                        case 1: {
                            Certificate certToAdd = this.convertPKIXRecordToCert(certRec);
                            if (certToAdd == null || !(certToAdd instanceof X509Certificate)) continue block12;
                            retVal.add((X509Certificate)certToAdd);
                            continue block12;
                        }
                        case 253: {
                            Certificate certToAdd = this.convertIPKIXRecordToCert(certRec);
                            if (certToAdd == null || !(certToAdd instanceof X509Certificate)) continue block12;
                            retVal.add((X509Certificate)certToAdd);
                            continue block12;
                        }
                        default: {
                            log.warn("Unknown CERT type {} encountered for lookup name {}", (Object)certRec.getCertType(), (Object)lookupName);
                        }
                    }
                }
            } else if (domain.length() < name.length()) {
                retVal = this.lookupDNS(domain);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NHINDException("", e);
        }
        if (retVal != null && retVal.size() > 0 && this.localStoreDelegate != null) {
            for (X509Certificate x509Certificate : retVal) {
                if (this.localStoreDelegate == null) continue;
                if (this.localStoreDelegate.contains(x509Certificate)) {
                    this.localStoreDelegate.update(x509Certificate);
                    continue;
                }
                this.localStoreDelegate.add(x509Certificate);
            }
            try {
                if (this.cache != null) {
                    this.cache.put((Object)name, retVal);
                }
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
        return retVal;
    }

    @Override
    public void flush(boolean purgeBootStrap) {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
            if (purgeBootStrap && this.localStoreDelegate != null) {
                this.localStoreDelegate.remove(this.localStoreDelegate.getAllCertificates());
            }
        }
    }

    @Override
    public void loadBootStrap() {
        if (this.localStoreDelegate == null) {
            throw new IllegalStateException("The boot strap store has not been set.");
        }
        JCS cache = null;
        cache = this.getCache();
        if (cache != null) {
            HashMap cacheBuilderMap = new HashMap();
            for (X509Certificate x509Certificate : this.localStoreDelegate.getAllCertificates()) {
            }
            for (Map.Entry entry : cacheBuilderMap.entrySet()) {
                try {
                    cache.put(entry.getKey(), entry.getValue());
                }
                catch (CacheException cacheException) {}
            }
        }
    }

    @Override
    public void loadBootStrap(CertificateStore bootstrapStore) {
        if (this.localStoreDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.localStoreDelegate = bootstrapStore;
        this.loadBootStrap();
    }

    @Override
    public void setBootStrap(CertificateStore bootstrapStore) {
        if (this.localStoreDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.localStoreDelegate = bootstrapStore;
    }

    @Override
    public void setCachePolicy(CertStoreCachePolicy policy) {
        this.cachePolicy = policy;
        this.applyCachePolicy(policy);
    }

    private void applyCachePolicy(CertStoreCachePolicy policy) {
        if (this.getCache() != null) {
            try {
                ICompositeCacheAttributes attributes = this.cache.getCacheAttributes();
                attributes.setMaxObjects(policy.getMaxItems());
                attributes.setUseLateral(false);
                attributes.setUseRemote(false);
                this.cache.setCacheAttributes(attributes);
                IElementAttributes eattributes = this.cache.getDefaultElementAttributes();
                eattributes.setMaxLifeSeconds((long)policy.getSubjectTTL());
                eattributes.setIsEternal(false);
                eattributes.setIsLateral(false);
                eattributes.setIsRemote(false);
                this.cache.setDefaultElementAttributes(eattributes);
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    protected ExtendedResolver createExResolver(String[] servers, int retries, int timeout) {
        ExtendedResolver extendedResolver = new ExtendedResolver();
        Object[] resolvers = extendedResolver.getResolvers();
        if (!ArrayUtils.isEmpty((Object[])resolvers)) {
            for (Object object : resolvers) {
                extendedResolver.deleteResolver((Resolver)object);
            }
        }
        if (!ArrayUtils.isEmpty((Object[])servers)) {
            for (String string : servers) {
                String string2 = string.replaceFirst("\\.$", "");
                try {
                    SimpleResolver simpleResolver = new SimpleResolver(string2);
                    extendedResolver.addResolver((Resolver)simpleResolver);
                }
                catch (UnknownHostException e) {
                    log.debug("unable to add resolver for {}", (Object)string2, (Object)e);
                }
            }
            extendedResolver.setRetries(retries);
            extendedResolver.setTimeout(Duration.ofSeconds(timeout));
            extendedResolver.setTCP(this.useTCP);
        }
        return extendedResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Certificate convertPKIXRecordToCert(CERTRecord certRec) {
        X509Certificate retVal = null;
        ByteArrayInputStream inputStream = null;
        byte[] certData = certRec.getCert();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            inputStream = new ByteArrayInputStream(certData);
            retVal = (X509Certificate)cf.generateCertificate(inputStream);
        }
        catch (Exception e) {
            try {
                log.warn("Failed to convert certificate from DNS byte data.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Certificate convertIPKIXRecordToCert(CERTRecord certRec) {
        X509Certificate retVal = null;
        InputStream inputStream = null;
        try {
            URL certURL = this.getCertURL(certRec);
            URLConnection connection = certURL.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            inputStream = connection.getInputStream();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            retVal = (X509Certificate)cf.generateCertificate(inputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (Exception e) {
            log.warn("Failed to get cert recrod from IPKIX location.", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return retVal;
    }

    protected URL getCertURL(CERTRecord certRec) throws MalformedURLException, UnsupportedEncodingException {
        URL certURL = new URL(new String(certRec.getCert(), "ASCII"));
        return certURL;
    }

    static {
        Cache ch = Lookup.getDefaultCache((int)1);
        ch.clearCache();
    }

    public static class DefaultDNSCachePolicy
    implements CertStoreCachePolicy {
        protected final int maxItems;
        protected final int subjectTTL;

        public DefaultDNSCachePolicy() {
            OptionsParameter param = OptionsManager.getInstance().getParameter("DNS_CERT_RESOLVER_MAX_CACHE_SIZE");
            this.maxItems = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)1000);
            param = OptionsManager.getInstance().getParameter("DNS_CERT_RESOLVER_CACHE_TTL");
            this.subjectTTL = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)3600);
        }

        @Override
        public int getMaxItems() {
            return this.maxItems;
        }

        @Override
        public int getSubjectTTL() {
            return this.subjectTTL;
        }
    }
}

