/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.util.Hashtable;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.impl.LDAPCertificateStore;
import org.nhindirect.stagent.cert.impl.LdapCertUtilImpl;
import org.nhindirect.stagent.cert.impl.LdapEnvironment;
import org.nhindirect.stagent.cert.impl.LdapStoreConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCertificateStoreFactory {
    private static final Logger log = LoggerFactory.getLogger(LdapCertificateStoreFactory.class);
    private static final String LDAP_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_TIMEOUT = "com.sun.jndi.ldap.read.timeout";

    public static CertificateResolver createInstance(LdapStoreConfiguration ldapConfiguration, CertificateStore bootstrapStore, CertStoreCachePolicy policy) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", LDAP_FACTORY);
        String[] ldapURLs = ldapConfiguration.getLdapURLs();
        String ldapProviderUrl = null;
        for (String ldapURL : ldapURLs) {
            ldapProviderUrl = ldapProviderUrl == null ? ldapURL + " " : ldapProviderUrl + ldapURL + " ";
        }
        env.put("java.naming.provider.url", ldapProviderUrl);
        if (ldapConfiguration.getLdapConnectionTimeOut() != null) {
            try {
                int connectionTimeOut = Integer.parseInt(ldapConfiguration.getLdapConnectionTimeOut());
                if (connectionTimeOut < 1) {
                    log.error("Connection timeout must be a positive integer");
                    throw new NHINDException("Invalid value for the LDAP connection timeout");
                }
            }
            catch (NumberFormatException nfe) {
                log.error("Connection timeout string is not a valid number.");
                throw new NHINDException("Invalid value for the LDAP connection timeout", (Exception)nfe);
            }
            env.put(LDAP_TIMEOUT, ldapConfiguration.getLdapConnectionTimeOut());
        }
        if (ldapConfiguration.getEmployLdapAuthInformation() != null) {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", ldapConfiguration.getEmployLdapAuthInformation().getLdapPrincipal());
            env.put("java.naming.security.credentials", ldapConfiguration.getEmployLdapAuthInformation().getLdapPassword());
        } else {
            env.put("java.naming.security.authentication", "none");
        }
        LdapEnvironment ldapEnvironment = new LdapEnvironment(env, ldapConfiguration.getReturningCertAttribute(), ldapConfiguration.getLdapSearchBase(), ldapConfiguration.getLdapSearchAttribute());
        LdapCertUtilImpl ldapcertUtilImpl = new LdapCertUtilImpl(ldapEnvironment, ldapConfiguration.getLdapCertPassphrase(), ldapConfiguration.getCertificateFormat());
        return new LDAPCertificateStore(ldapcertUtilImpl, bootstrapStore, policy);
    }
}

