/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.mail.internet.InternetAddress;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.X509Store;

public class UniformCertificateStore
implements CertificateResolver {
    private Collection<X509Certificate> certs;

    public UniformCertificateStore(X509Certificate cert) {
        this.certs = new ArrayList<X509Certificate>();
        this.certs.add(cert);
    }

    public UniformCertificateStore(Collection<X509Certificate> certs) {
        this.setCertificates(certs);
    }

    public UniformCertificateStore(X509Store certs) {
        if (certs == null) {
            throw new IllegalArgumentException();
        }
        this.setCertificates(certs.getAllCertificates());
    }

    public void setCertificates(Collection<X509Certificate> certs) {
        if (certs == null || certs.size() == 0) {
            throw new IllegalArgumentException("Empty or null certificates are not allowed");
        }
        this.certs = new ArrayList<X509Certificate>(certs);
    }

    @Override
    public Collection<X509Certificate> getCertificates(InternetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException();
        }
        return Collections.unmodifiableCollection(this.certs);
    }
}

