/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.cms.CMSSignedData;
import org.nhindirect.stagent.SignatureValidationException;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cryptography.SignedEntity;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;

public interface Cryptographer {
    public MimeEntity encrypt(MimeMultipart var1, X509Certificate var2);

    public MimeEntity encrypt(MimeMultipart var1, Collection<X509Certificate> var2);

    public MimeEntity encrypt(MimeEntity var1, X509Certificate var2);

    public MimeEntity encrypt(MimeEntity var1, Collection<X509Certificate> var2);

    public MimeEntity decrypt(Message var1, X509CertificateEx var2);

    public MimeEntity decrypt(MimeEntity var1, X509CertificateEx var2);

    public MimeEntity decrypt(MimeEntity var1, Collection<X509CertificateEx> var2);

    public SignedEntity sign(Message var1, X509Certificate var2);

    public SignedEntity sign(Message var1, Collection<X509Certificate> var2);

    public SignedEntity sign(MimeEntity var1, X509Certificate var2);

    public SignedEntity sign(MimeEntity var1, Collection<X509Certificate> var2);

    public void checkSignature(SignedEntity var1, X509Certificate var2, Collection<X509Certificate> var3) throws SignatureValidationException;

    public CMSSignedData deserializeSignatureEnvelope(SignedEntity var1);

    public CMSSignedData deserializeEnvelopedSignature(MimeEntity var1);

    public CMSSignedData deserializeEnvelopedSignature(byte[] var1);
}

