/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;

public enum EncryptionAlgorithm {
    RSA_3DES("RSA_3DES", SMIMEEnvelopedGenerator.DES_EDE3_CBC),
    AES128("AES128", SMIMEEnvelopedGenerator.AES128_CBC),
    AES192("AES192", SMIMEEnvelopedGenerator.AES192_CBC),
    AES256("AES256", SMIMEEnvelopedGenerator.AES256_CBC),
    DSA("DSA", CMSSignedDataGenerator.ENCRYPTION_DSA),
    RSA("RSA", CMSSignedDataGenerator.ENCRYPTION_RSA),
    RSAandMGF1("RSAandMGF1", CMSSignedDataGenerator.ENCRYPTION_RSA_PSS),
    ECDSA("ECDSA", CMSSignedDataGenerator.ENCRYPTION_ECDSA),
    DES_EDE3_CBC("DESEDE/CBC/PKCS5Padding", CMSEnvelopedGenerator.DES_EDE3_CBC),
    AES128_CBC("AES/CBC/PKCS5Padding", CMSEnvelopedGenerator.AES128_CBC),
    AES192_CBC("AES/CBC/PKCS5Padding", CMSEnvelopedGenerator.AES192_CBC),
    AES256_CBC("AES/CBC/PKCS5Padding", CMSEnvelopedGenerator.AES256_CBC);

    protected final String algName;
    protected final String OID;

    private EncryptionAlgorithm(String algName, String OID) {
        this.algName = algName;
        this.OID = OID;
    }

    public static EncryptionAlgorithm fromString(String algorithmName, EncryptionAlgorithm defaultAlgorithm) {
        if (algorithmName == null || algorithmName.isEmpty()) {
            return defaultAlgorithm;
        }
        if (algorithmName.equalsIgnoreCase(RSA_3DES.getAlgName())) {
            return RSA_3DES;
        }
        if (algorithmName.equalsIgnoreCase(AES128.getAlgName())) {
            return AES128;
        }
        if (algorithmName.equalsIgnoreCase(AES192.getAlgName())) {
            return AES192;
        }
        if (algorithmName.equalsIgnoreCase(AES256.getAlgName())) {
            return AES256;
        }
        if (algorithmName.equalsIgnoreCase(DSA.getAlgName())) {
            return DSA;
        }
        if (algorithmName.equalsIgnoreCase(RSA.getAlgName())) {
            return RSA;
        }
        if (algorithmName.equalsIgnoreCase(RSAandMGF1.getAlgName())) {
            return RSAandMGF1;
        }
        if (algorithmName.equalsIgnoreCase(ECDSA.getAlgName())) {
            return ECDSA;
        }
        return defaultAlgorithm;
    }

    public static EncryptionAlgorithm fromOID(String OID, EncryptionAlgorithm defaultAlgorithm) {
        if (StringUtils.isEmpty((CharSequence)OID)) {
            return defaultAlgorithm;
        }
        if (OID.equalsIgnoreCase(RSA_3DES.getOID())) {
            return RSA_3DES;
        }
        if (OID.equalsIgnoreCase(RSA_3DES.getOID())) {
            return RSA_3DES;
        }
        if (OID.equalsIgnoreCase(AES128.getOID())) {
            return AES128;
        }
        if (OID.equalsIgnoreCase(AES192.getOID())) {
            return AES192;
        }
        if (OID.equalsIgnoreCase(AES256.getOID())) {
            return AES256;
        }
        if (OID.equalsIgnoreCase(DSA.getOID())) {
            return DSA;
        }
        if (OID.equalsIgnoreCase(RSA.getOID())) {
            return RSA;
        }
        if (OID.equalsIgnoreCase(RSAandMGF1.getOID())) {
            return RSAandMGF1;
        }
        if (OID.equalsIgnoreCase(ECDSA.getOID())) {
            return ECDSA;
        }
        return defaultAlgorithm;
    }

    public String getOID() {
        return this.OID;
    }

    public String getAlgName() {
        return this.algName;
    }
}

