/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.x509.AuthorityInfoAccessExtentionField;
import org.nhindirect.policy.x509.AuthorityInfoAccessMethodIdentifier;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.Thumbprint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustChainValidator {
    private static final Logger log = LoggerFactory.getLogger(TrustChainValidator.class);
    private static final int RFC822Name_TYPE = 1;
    private static final int DNSName_TYPE = 2;
    private static final String CA_ISSUER_CHECK_STRING = AuthorityInfoAccessMethodIdentifier.CA_ISSUERS.getName() + ":";
    protected static final int DEFAULT_URL_CONNECTION_TIMEOUT = 10000;
    protected static final int DEFAULT_URL_READ_TIMEOUT = 10000;
    private static int DefaultMaxIssuerChainLength = 5;
    private Collection<CertificateResolver> certResolvers = Collections.emptyList();
    private int maxIssuerChainLength = DefaultMaxIssuerChainLength;

    public boolean isCertificateResolver() {
        return this.certResolvers != null && this.certResolvers.size() > 0;
    }

    public Collection<CertificateResolver> getCertificateResolver() {
        return this.certResolvers;
    }

    public void setCertificateResolver(Collection<CertificateResolver> resolver) {
        this.certResolvers = resolver;
    }

    public boolean isTrusted(X509Certificate certificate, Collection<X509Certificate> anchors) {
        if (certificate == null) {
            throw new IllegalArgumentException();
        }
        if (anchors == null || anchors.size() == 0) {
            return false;
        }
        try {
            Collection<X509Certificate> intermediatesCerts;
            if (this.isIssuerInAnchors(anchors, certificate)) {
                return true;
            }
            CertPath certPath = null;
            CertificateFactory factory = CertificateFactory.getInstance("X509");
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            certs.add(certificate);
            if (this.certResolvers != null && (intermediatesCerts = this.resolveIntermediateIssuers(certificate, anchors)) != null && intermediatesCerts.size() > 0) {
                certs.addAll(intermediatesCerts);
            }
            HashSet<TrustAnchor> trustAnchorSet = new HashSet<TrustAnchor>();
            for (X509Certificate archor : anchors) {
                trustAnchorSet.add(new TrustAnchor(archor, null));
            }
            PKIXParameters params = new PKIXParameters(trustAnchorSet);
            params.setRevocationEnabled(false);
            certPath = factory.generateCertPath(certs);
            CertPathValidator pathValidator = CertPathValidator.getInstance("PKIX", CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm((String)"CertPathValidator", (String)"PKIX"));
            pathValidator.validate(certPath, params);
            return true;
        }
        catch (Exception e) {
            log.warn("Certificate {} is not trusted.", (Object)certificate.getSubjectX500Principal().getName(), (Object)e);
            return false;
        }
    }

    private Collection<X509Certificate> resolveIntermediateIssuers(X509Certificate certificate, Collection<X509Certificate> anchors) {
        ArrayList<X509Certificate> issuers = new ArrayList<X509Certificate>();
        this.resolveIntermediateIssuers(certificate, issuers, anchors);
        return issuers;
    }

    private void resolveIntermediateIssuers(X509Certificate certificate, Collection<X509Certificate> issuers, Collection<X509Certificate> anchors) {
        if (certificate == null) {
            throw new IllegalArgumentException("Certificate cannot be null.");
        }
        if (issuers == null) {
            throw new IllegalArgumentException("Issuers collection cannot be null.");
        }
        this.resolveIssuers(certificate, issuers, 0, anchors);
    }

    private boolean isIssuerInCollection(Collection<X509Certificate> issuers, X509Certificate checkIssuer) {
        for (X509Certificate issuer : issuers) {
            if (!checkIssuer.getSubjectX500Principal().equals(issuer.getSubjectX500Principal()) || !Thumbprint.toThumbprint(issuer).equals(Thumbprint.toThumbprint(checkIssuer))) continue;
            return true;
        }
        return false;
    }

    private boolean isIssuerInAnchors(Collection<X509Certificate> anchors, X509Certificate checkIssuer) {
        ASN1Object checkIssuerExValue = this.getExtensionValue(checkIssuer, "2.5.29.14");
        for (X509Certificate anchor : anchors) {
            if (Thumbprint.toThumbprint(anchor).equals(Thumbprint.toThumbprint(checkIssuer))) {
                return true;
            }
            ASN1Object anchorExValue = this.getExtensionValue(anchor, "2.5.29.14");
            if (checkIssuerExValue == null || anchorExValue == null || !anchorExValue.equals((Object)checkIssuerExValue)) continue;
            return true;
        }
        return false;
    }

    protected void resolveIssuers(X509Certificate certificate, Collection<X509Certificate> issuers, int chainLength, Collection<X509Certificate> anchors) {
        X500Principal issuerPrin = certificate.getIssuerX500Principal();
        if (issuerPrin.equals(certificate.getSubjectX500Principal())) {
            return;
        }
        for (X509Certificate issuer : issuers) {
            if (!issuerPrin.equals(issuer.getSubjectX500Principal())) continue;
            return;
        }
        if (chainLength >= this.maxIssuerChainLength) {
            return;
        }
        Collection<X509Certificate> issuerCerts = this.getIntermediateCertsByAIA(certificate);
        if (issuerCerts.isEmpty()) {
            String address = this.getIssuerAddress(certificate);
            if (address == null || address.isEmpty()) {
                return;
            }
            for (CertificateResolver publicResolver : this.certResolvers) {
                Collection<X509Certificate> holdCerts = null;
                try {
                    holdCerts = publicResolver.getCertificates(new InternetAddress(address));
                }
                catch (AddressException e) {
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (holdCerts == null || holdCerts.size() <= 0) continue;
                issuerCerts.addAll(holdCerts);
            }
        }
        if (issuerCerts.size() == 0) {
            return;
        }
        boolean issuerFoundInAnchors = false;
        ArrayList<X509Certificate> searchForParentIssuers = new ArrayList<X509Certificate>();
        for (X509Certificate issuerCert : issuerCerts) {
            if (issuerCert.getSubjectX500Principal().equals(issuerPrin) && !this.isIssuerInCollection(issuers, issuerCert) && !this.isIssuerInAnchors(anchors, issuerCert)) {
                searchForParentIssuers.add(issuerCert);
                continue;
            }
            if (!this.isIssuerInAnchors(anchors, issuerCert)) continue;
            issuerFoundInAnchors = true;
            break;
        }
        if (!issuerFoundInAnchors) {
            for (X509Certificate issuerCert : searchForParentIssuers) {
                issuers.add(issuerCert);
                this.resolveIssuers(issuerCert, issuers, chainLength + 1, anchors);
            }
        }
    }

    protected Collection<X509Certificate> getIntermediateCertsByAIA(X509Certificate certificate) {
        ArrayList<X509Certificate> retVal = new ArrayList<X509Certificate>();
        AuthorityInfoAccessExtentionField aiaField = new AuthorityInfoAccessExtentionField(false);
        try {
            aiaField.injectReferenceValue(certificate);
            Collection urlPairs = (Collection)aiaField.getPolicyValue().getPolicyValue();
            for (String urlPair : urlPairs) {
                if (!urlPair.startsWith(CA_ISSUER_CHECK_STRING)) continue;
                String url = urlPair.substring(CA_ISSUER_CHECK_STRING.length());
                try {
                    Collection<X509Certificate> intermCerts = this.downloadCertsFromAIA(url);
                    retVal.addAll(intermCerts);
                }
                catch (NHINDException e) {
                    log.warn("Intermediate cert cannot be resolved from AIA extension.", (Throwable)e);
                }
            }
        }
        catch (PolicyProcessException e) {
            log.warn("Intermediate cert cannot be resolved from AIA extension.", (Throwable)e);
        }
        return retVal;
    }

    protected X509Certificate downloadCertFromAIA(String url) throws NHINDException {
        InputStream inputStream = null;
        X509Certificate retVal = null;
        try {
            URL certURL = new URL(url);
            URLConnection connection = certURL.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            inputStream = connection.getInputStream();
            retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
        }
        catch (Exception e) {
            try {
                throw new NHINDException("Failed to download certificate from AIA extension.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return retVal;
    }

    protected Collection<X509Certificate> downloadCertsFromAIA(String url) throws NHINDException {
        InputStream inputStream = null;
        Collection<? extends Certificate> retVal = null;
        try {
            URL certURL = new URL(url);
            URLConnection connection = certURL.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            inputStream = connection.getInputStream();
            retVal = CertificateFactory.getInstance("X.509").generateCertificates(inputStream);
        }
        catch (Exception e) {
            try {
                throw new NHINDException("Failed to download certificates from AIA extension (URL: " + url + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return retVal;
    }

    private String getIssuerAddress(X509Certificate certificate) {
        String address = "";
        Collection<List<?>> altNames = null;
        try {
            altNames = certificate.getIssuerAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        if (altNames != null) {
            for (List<?> entries : altNames) {
                if (entries.size() < 2) continue;
                Integer nameType = (Integer)entries.get(0);
                if (nameType == 1) {
                    address = (String)entries.get(1);
                    continue;
                }
                if (nameType != 2 || !address.isEmpty()) continue;
                address = (String)entries.get(1);
            }
        }
        return address;
    }

    private ASN1Object getExtensionValue(X509Certificate cert, String oid) {
        byte[] bytes = cert.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        return this.getObject(bytes);
    }

    private ASN1Object getObject(byte[] ext) {
        ASN1Primitive aSN1Primitive;
        ASN1InputStream aIn = null;
        try {
            aIn = new ASN1InputStream(ext);
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            IOUtils.closeQuietly((InputStream)aIn);
            aIn = new ASN1InputStream(octs.getOctets());
            aSN1Primitive = aIn.readObject();
        }
        catch (Exception e) {
            try {
                throw new IllegalArgumentException("Exception processing data ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(aIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)aIn);
        return aSN1Primitive;
    }

    static {
        Security.setProperty("ocsp.enable", "true");
    }
}

