/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.mail.smime.CMSProcessableBodyPartInbound;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.stagent.DefaultMessageSignatureImpl;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cryptography.CryptoAlgorithmsHelper;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.TestUtils;

public class DefaultMessageSignatureImpl_CheckThumbprint_Test {
    @Test
    public void testMessageSenderDoesNotHaveCertificates_ReturnsFalse() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasCertificates_Internal() {
                this.theHasCertificates = false;
                return this.theHasCertificates;
            }

            @Override
            protected void doAssertions(boolean checkThumbprint) throws Exception {
                Assertions.assertFalse((boolean)checkThumbprint);
            }
        }.perform();
    }

    @Test
    public void testThumbprintMatches_ReturnsTrue() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasCertificates_Internal() {
                this.theHasCertificates = true;
                return this.theHasCertificates;
            }

            @Override
            protected void doAssertions(boolean checkThumbprint) throws Exception {
                Assertions.assertTrue((boolean)checkThumbprint);
            }
        }.perform();
    }

    @Test
    public void testThumbprintDoesNotMatch_ReturnsFalse() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasCertificates_Internal() {
                this.theHasCertificates = true;
                return this.theHasCertificates;
            }

            @Override
            protected DefaultMessageSignatureImpl createMessageSignature() throws Exception {
                return new DefaultMessageSignatureImpl(this.createSignerInformation(), false, (X509Certificate)TestUtils.getInternalCert("bob")){};
            }

            @Override
            protected void doAssertions(boolean checkThumbprint) throws Exception {
                Assertions.assertFalse((boolean)checkThumbprint);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected NHINDAddress theCreateMessageSender;
        protected Collection<X509Certificate> theGetCertificates;
        protected int getCertificatesCalls = 0;
        protected boolean theHasCertificates;
        protected int hasCertificatesCalls = 0;

        TestPlan() {
        }

        @Override
        protected void setupMocks() {
            CryptoExtensions.registerJCEProviders();
        }

        @Override
        protected void performInner() throws Exception {
            DefaultMessageSignatureImpl impl = this.createMessageSignature();
            boolean checkThumbprint = impl.checkThumbprint(this.createMessageSender());
            this.doAssertions(checkThumbprint);
        }

        protected DefaultMessageSignatureImpl createMessageSignature() throws Exception {
            return new DefaultMessageSignatureImpl(this.createSignerInformation(), false, this.theGetCertificates.iterator().next()){};
        }

        protected NHINDAddress createMessageSender() throws Exception {
            this.theCreateMessageSender = new NHINDAddress(""){

                public boolean hasCertificates() {
                    ++TestPlan.this.hasCertificatesCalls;
                    return TestPlan.this.hasCertificates_Internal();
                }

                public Collection<X509Certificate> getCertificates() {
                    ++TestPlan.this.getCertificatesCalls;
                    return TestPlan.this.getCertificates_Internal();
                }
            };
            return this.theCreateMessageSender;
        }

        protected Collection<X509Certificate> getCertificates_Internal() {
            return this.theGetCertificates;
        }

        protected boolean hasCertificates_Internal() {
            this.theHasCertificates = false;
            return this.theHasCertificates;
        }

        protected SignerInformation createSignerInformation() throws Exception {
            X509CertificateEx internalCert = TestUtils.getInternalCert("user1");
            String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
            MimeMessage entity = EntitySerializer.Default.deserialize(testMessage);
            Message message = new Message(entity);
            MimeEntity entityToSig = message.extractEntityForSignature(true);
            byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)entityToSig);
            MimeBodyPart partToSign = null;
            try {
                partToSign = new MimeBodyPart((InputStream)new ByteArrayInputStream(messageBytes));
            }
            catch (Exception exception) {
                // empty catch block
            }
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
            SMIMECapabilityVector caps = new SMIMECapabilityVector();
            caps.addCapability(SMIMECapability.dES_EDE3_CBC);
            caps.addCapability(SMIMECapability.rC2_CBC, 128);
            caps.addCapability(SMIMECapability.dES_CBC);
            caps.addCapability(new ASN1ObjectIdentifier("1.2.840.113549.1.7.1"));
            caps.addCapability(PKCSObjectIdentifiers.x509Certificate);
            signedAttrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(caps));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            ContentSigner sha1Signer = new JcaContentSignerBuilder(DigestAlgorithm.SHA256WITHRSA.getAlgName()).setProvider(CryptoExtensions.getJCESensitiveProviderName()).build(internalCert.getPrivateKey());
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(CryptoExtensions.getJCEProviderName()).build()).build(sha1Signer, (X509Certificate)internalCert));
            certList.add((X509Certificate)internalCert);
            this.theGetCertificates = certList;
            MimeMultipart retVal = new MimeMultipart();
            JcaCertStore certs = new JcaCertStore(certList);
            gen.addCertificates((Store)certs);
            CMSProcessableByteArray content = new CMSProcessableByteArray(messageBytes);
            CMSSignedData signedData = gen.generate((CMSTypedData)content);
            String header = "signed; protocol=\"application/pkcs7-signature\"; micalg=" + CryptoAlgorithmsHelper.toDigestAlgorithmMicalg((DigestAlgorithm)DigestAlgorithm.SHA256WITHRSA);
            String encodedSig = StringUtils.toEncodedString((byte[])Base64.encodeBase64((byte[])signedData.getEncoded(), (boolean)true), (Charset)StandardCharsets.UTF_8);
            retVal = new MimeMultipart(header.toString());
            MimeBodyPart sig = new MimeBodyPart(new InternetHeaders(), encodedSig.getBytes("ASCII"));
            sig.addHeader("Content-Type", "application/pkcs7-signature; name=smime.p7s; smime-type=signed-data");
            sig.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            sig.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            sig.addHeader("Content-Transfer-Encoding", "base64");
            retVal.addBodyPart((BodyPart)partToSign);
            retVal.addBodyPart((BodyPart)sig);
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            retVal.writeTo((OutputStream)oStream);
            oStream.flush();
            byte[] serialzedBytes = oStream.toByteArray();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(serialzedBytes, retVal.getContentType());
            MimeMultipart verifyMM = new MimeMultipart((DataSource)dataSource);
            CMSSignedData signeddata = new CMSSignedData((CMSProcessable)new CMSProcessableBodyPartInbound((BodyPart)partToSign), verifyMM.getBodyPart(1).getInputStream());
            SignerInformationStore signers = signeddata.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            if (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                return signer;
            }
            return null;
        }

        protected void doAssertions(boolean checkThumbprint) throws Exception {
        }
    }
}

