/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import javax.mail.internet.MimeMessage;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.DefaultMessageEnvelope;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.MessageEnvelope;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class DefaultNHINDAgent_ProcessOutgoing_AsMessageEnvelope_Test {
    @Test
    public void testMessageEnvelopeIsNull_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected MessageEnvelope createEnvelope() throws Exception {
                this.theCreateEnvelope = null;
                return this.theCreateEnvelope;
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                Assertions.fail((String)"");
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                org.junit.jupiter.api.Assertions.assertNull((Object)this.theCreateEnvelope);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    @Test
    public void testCorrectMessageEnvelopeIsPassedToCheckEnvelopeAddressesMethod() throws Exception {
        new TestPlan(){

            @Override
            protected void checkEnvelopeAddresses_Internal(MessageEnvelope envelope) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)this.theCreateEnvelope, (Object)envelope);
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.checkEnvelopeAddressesCalls);
            }
        }.perform();
    }

    @Test
    public void testMessageEnvelopeIsNotNull_ProcessOutgoingMethodIsCalled() throws Exception {
        new TestPlan(){

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.processOutgoingCalls);
                org.junit.jupiter.api.Assertions.assertNotNull((Object)this.theProcessOutgoing);
                org.junit.jupiter.api.Assertions.assertEquals((Object)this.theProcessOutgoing, (Object)processOutgoing);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int checkEnvelopeAddressesCalls = 0;
        protected MessageEnvelope theCreateEnvelope;
        protected OutgoingMessage theProcessOutgoing;
        protected int processOutgoingCalls = 0;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createDefaultNHINDAgent();
            OutgoingMessage processOutgoing = impl.processOutgoing(this.createEnvelope());
            this.doAssertions(processOutgoing);
        }

        protected DefaultNHINDAgent createDefaultNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                protected void checkEnvelopeAddresses(MessageEnvelope envelope) {
                    ++TestPlan.this.checkEnvelopeAddressesCalls;
                    TestPlan.this.checkEnvelopeAddresses_Internal(envelope);
                }

                public OutgoingMessage processOutgoing(OutgoingMessage message) {
                    ++TestPlan.this.processOutgoingCalls;
                    return TestPlan.this.processOutgoing_Internal(message);
                }
            };
        }

        protected void checkEnvelopeAddresses_Internal(MessageEnvelope envelope) {
        }

        protected MessageEnvelope createEnvelope() throws Exception {
            SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
            mimeMsg.setText("");
            Message msg = new Message((MimeMessage)mimeMsg);
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add((Object)new NHINDAddress(""));
            NHINDAddress sender = new NHINDAddress("");
            this.theCreateEnvelope = new DefaultMessageEnvelope(msg, recipients, sender);
            return this.theCreateEnvelope;
        }

        protected OutgoingMessage processOutgoing_Internal(OutgoingMessage message) {
            this.theProcessOutgoing = message;
            return this.theProcessOutgoing;
        }

        protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
        }
    }
}

