/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class DefaultNHINDAgent_ProcessOutgoing_RawStringAndAddresses_Test {
    @Test
    public void testCorrectRecipientsParamIsPassedToCheckEnvelopeAddresses() throws Exception {
        new TestPlan(){

            @Override
            protected void checkEnvelopeAddresses_Internal(NHINDAddressCollection recipients, NHINDAddress sender) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)this.theCreateRecipients, (Object)recipients);
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.checkEnvelopeAddressesCalls);
            }
        }.perform();
    }

    @Test
    public void testCorrectSenderParamIsPassedToCheckEnvelopeAddresses() throws Exception {
        new TestPlan(){

            @Override
            protected void checkEnvelopeAddresses_Internal(NHINDAddressCollection recipients, NHINDAddress sender) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)this.theCreateSender, (Object)sender);
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.checkEnvelopeAddressesCalls);
            }
        }.perform();
    }

    @Test
    public void testCorrectMessageTxtParamIsPassedToWrapMessage() throws Exception {
        new TestPlan(){

            @Override
            protected Message wrapMessage_Internal(String messageText) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)this.theCreateMessageText, (Object)messageText);
                return super.wrapMessage_Internal(messageText);
            }

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.wrapMessageCalls);
            }
        }.perform();
    }

    @Test
    public void testProcessOutgoingMethodIsCalled() throws Exception {
        new TestPlan(){

            @Override
            protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.processOutgoingCalls);
                org.junit.jupiter.api.Assertions.assertEquals((Object)this.theProcessOutgoing, (Object)processOutgoing);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int checkEnvelopeAddressesCalls = 0;
        protected Message theWrapMessage;
        protected int wrapMessageCalls = 0;
        protected OutgoingMessage theProcessOutgoing;
        protected int processOutgoingCalls = 0;
        protected String theCreateMessageText;
        protected NHINDAddressCollection theCreateRecipients;
        protected NHINDAddress theCreateSender;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createDefaultNHINDAgent();
            OutgoingMessage processOutgoing = impl.processOutgoing(this.createMessageText(), this.createRecipients(), this.createSender());
            this.doAssertions(processOutgoing);
        }

        protected DefaultNHINDAgent createDefaultNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                protected void checkEnvelopeAddresses(NHINDAddressCollection recipients, NHINDAddress sender) {
                    ++TestPlan.this.checkEnvelopeAddressesCalls;
                    TestPlan.this.checkEnvelopeAddresses_Internal(recipients, sender);
                }

                protected Message wrapMessage(String messageText) {
                    ++TestPlan.this.wrapMessageCalls;
                    return TestPlan.this.wrapMessage_Internal(messageText);
                }

                public OutgoingMessage processOutgoing(OutgoingMessage message) {
                    ++TestPlan.this.processOutgoingCalls;
                    return TestPlan.this.processOutgoing_Internal(message);
                }
            };
        }

        protected void checkEnvelopeAddresses_Internal(NHINDAddressCollection recipients, NHINDAddress sender) {
        }

        protected Message wrapMessage_Internal(String messageText) {
            try {
                Message msg;
                SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
                mimeMsg.setText("");
                mimeMsg.setRecipients(Message.RecipientType.TO, "some");
                mimeMsg.setSender((Address)new InternetAddress());
                this.theWrapMessage = msg = new Message((MimeMessage)mimeMsg);
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)"");
            }
            return this.theWrapMessage;
        }

        protected OutgoingMessage processOutgoing_Internal(OutgoingMessage message) {
            this.theProcessOutgoing = message;
            return this.theProcessOutgoing;
        }

        protected String createMessageText() throws Exception {
            this.theCreateMessageText = "createMessageText";
            return this.theCreateMessageText;
        }

        protected NHINDAddressCollection createRecipients() throws Exception {
            this.theCreateRecipients = new NHINDAddressCollection();
            this.theCreateRecipients.add((Object)new NHINDAddress(""));
            return this.theCreateRecipients;
        }

        protected NHINDAddress createSender() throws Exception {
            this.theCreateSender = new NHINDAddress("");
            return this.theCreateSender;
        }

        protected void doAssertions(OutgoingMessage processOutgoing) throws Exception {
        }
    }
}

