/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsManagerUtils;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.MessageEnvelope;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.TestUtils;

public class DefaultNHINDAgent_enforceTamperPolicyTest {
    protected Message originalMessage;
    protected DefaultNHINDAgent agent;

    @BeforeEach
    public void setUp() throws Exception {
        OptionsManagerUtils.clearOptionsManagerInstance();
        String testMessage = TestUtils.readResource("MessageWithAttachment.txt");
        this.originalMessage = new Message(new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII"))));
        this.agent = new DefaultNHINDAgent("widget", (CertificateResolver)Mockito.mock(CertificateResolver.class), (CertificateResolver)Mockito.mock(CertificateResolver.class), (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
    }

    @AfterEach
    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    @Test
    public void testEnforceTamperPolicy_tamperedSingleRecip_policyOn_assertException() throws Exception {
        Assertions.assertThrows(AgentException.class, () -> {
            NHINDAddressCollection recipients = NHINDAddressCollection.create(Collections.singleton(new NHINDAddress("not@exists.com")));
            NHINDAddress sender = new NHINDAddress(this.originalMessage.getFrom()[0].toString());
            IncomingMessage msg = new IncomingMessage(this.originalMessage, recipients, sender);
            this.agent.enforceTamperPolicy((MessageEnvelope)msg);
        });
    }

    @Test
    public void testEnforceTamperPolicy_tamperedMultipleRecips_policyOn_assertException() throws Exception {
        Assertions.assertThrows(AgentException.class, () -> {
            ArrayList<NHINDAddress> recips = new ArrayList<NHINDAddress>();
            Arrays.stream(this.originalMessage.getAllRecipients()).forEach(addr -> recips.add(new NHINDAddress((InternetAddress)addr)));
            recips.add(new NHINDAddress("not@exists.com"));
            NHINDAddressCollection recipients = NHINDAddressCollection.create(recips);
            NHINDAddress sender = new NHINDAddress(this.originalMessage.getFrom()[0].toString());
            IncomingMessage msg = new IncomingMessage(this.originalMessage, recipients, sender);
            this.agent.enforceTamperPolicy((MessageEnvelope)msg);
        });
    }

    @Test
    public void testEnforceTamperPolicy_tamperedFrom_policyOn_assertException() throws Exception {
        Assertions.assertThrows(AgentException.class, () -> {
            ArrayList recips = new ArrayList();
            Arrays.stream(this.originalMessage.getAllRecipients()).forEach(addr -> recips.add(new NHINDAddress((InternetAddress)addr)));
            NHINDAddressCollection recipients = NHINDAddressCollection.create(recips);
            NHINDAddress sender = new NHINDAddress("not@exists.com");
            IncomingMessage msg = new IncomingMessage(this.originalMessage, recipients, sender);
            this.agent.enforceTamperPolicy((MessageEnvelope)msg);
        });
    }

    @Test
    public void testEnforceTamperPolicy_tamperedSingleRecip_policyOff_noException() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("REJECT_ON_ROUTING_TAMPER", "false"));
        NHINDAddressCollection recipients = NHINDAddressCollection.create(Collections.singleton(new NHINDAddress("not@exists.com")));
        NHINDAddress sender = new NHINDAddress(this.originalMessage.getFrom()[0].toString());
        IncomingMessage msg = new IncomingMessage(this.originalMessage, recipients, sender);
        this.agent.enforceTamperPolicy((MessageEnvelope)msg);
    }

    @Test
    public void testEnforceTamperPolicy_tamperedFrom_policyOff_noException() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("REJECT_ON_ROUTING_TAMPER", "false"));
        ArrayList recips = new ArrayList();
        Arrays.stream(this.originalMessage.getAllRecipients()).forEach(addr -> recips.add(new NHINDAddress((InternetAddress)addr)));
        NHINDAddressCollection recipients = NHINDAddressCollection.create(recips);
        NHINDAddress sender = new NHINDAddress("not@exists.com");
        IncomingMessage msg = new IncomingMessage(this.originalMessage, recipients, sender);
        this.agent.enforceTamperPolicy((MessageEnvelope)msg);
    }

    @Test
    public void testEnforceTamperPolicy_untampered_noException() throws Exception {
        ArrayList recips = new ArrayList();
        Arrays.stream(this.originalMessage.getAllRecipients()).forEach(addr -> recips.add(new NHINDAddress((InternetAddress)addr)));
        NHINDAddressCollection recipients = NHINDAddressCollection.create(recips);
        NHINDAddress sender = new NHINDAddress(this.originalMessage.getFrom()[0].toString());
        IncomingMessage msg = new IncomingMessage(this.originalMessage, recipients, sender);
        this.agent.enforceTamperPolicy((MessageEnvelope)msg);
    }
}

