/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.stagent.cert.impl.CRLRevocationManager;

public class CRLRevocationManager_getCacheFileNameTest {
    @BeforeEach
    public void setUp() {
        CryptoExtensions.registerJCEProviders();
        CRLRevocationManager.initCRLCacheLocation();
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.crlCacheLocation = null;
    }

    @AfterEach
    public void tearDown() {
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.initCRLCacheLocation();
    }

    @Test
    public void testGetCacheName_uniqueNames() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        String uriName1 = CRLRevocationManager.getCacheFileName((String)"http://localhost:8080/master.crl");
        Assertions.assertNotNull((Object)uriName1);
        Assertions.assertTrue((boolean)uriName1.contains("CrlCache"));
        String uriName2 = CRLRevocationManager.getCacheFileName((String)"http://localhost/master.crl");
        Assertions.assertNotNull((Object)uriName2);
        Assertions.assertTrue((boolean)uriName2.contains("CrlCache"));
        Assertions.assertFalse((boolean)uriName1.equals(uriName2));
    }

    @Test
    public void testGetCacheName_sameNames() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        String uriName1 = CRLRevocationManager.getCacheFileName((String)"http://localhost:8080/master.crl");
        Assertions.assertNotNull((Object)uriName1);
        Assertions.assertTrue((boolean)uriName1.contains("CrlCache"));
        String uriName2 = CRLRevocationManager.getCacheFileName((String)"http://localhost:8080/master.crl");
        Assertions.assertNotNull((Object)uriName2);
        Assertions.assertTrue((boolean)uriName2.contains("CrlCache"));
        Assertions.assertEquals((Object)uriName1, (Object)uriName2);
    }

    @Test
    public void testGetCacheName_nullCacheLocation_assertEmptyName() throws Exception {
        String uriName1 = CRLRevocationManager.getCacheFileName((String)"http://localhost:8080/master.crl");
        Assertions.assertNotNull((Object)uriName1);
        Assertions.assertEquals((Object)"", (Object)uriName1);
    }
}

