/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.stagent.cert.impl.CRLRevocationManager;
import org.nhindirect.stagent.utils.TestUtils;

public class CRLRevocationManager_removeCRLCacheFileTest {
    @BeforeEach
    public void setUp() {
        CryptoExtensions.registerJCEProviders();
        CRLRevocationManager.initCRLCacheLocation();
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.crlCacheLocation = null;
    }

    @AfterEach
    public void tearDown() {
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.initCRLCacheLocation();
    }

    @Test
    public void testRemoveCRLCacheFile_removeExistingFile() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        CRL crlToWrite = TestUtils.loadCRL("certs.crl");
        String distURI = "http://localhost:8080/config";
        CRLRevocationManager.getInstance().writeCRLCacheFile(distURI, (X509CRL)crlToWrite);
        File crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        Assertions.assertTrue((boolean)crlFile.exists());
        CRLRevocationManager.getInstance().removeCrlCacheFile(distURI);
        crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        Assertions.assertFalse((boolean)crlFile.exists());
    }

    @Test
    public void testRemoveCRLCacheFile_removeNonExistingFile() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        String distURI = "http://localhost:8080/config";
        File crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        Assertions.assertFalse((boolean)crlFile.exists());
        CRLRevocationManager.getInstance().removeCrlCacheFile(distURI);
        crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        Assertions.assertFalse((boolean)crlFile.exists());
    }

    @Test
    public void testRemoveCRLCacheFile_noCacheLoction() throws Exception {
        String distURI = "http://localhost:8080/config";
        Assertions.assertEquals((Object)"", (Object)CRLRevocationManager.getCacheFileName((String)distURI));
        File crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        Assertions.assertFalse((boolean)crlFile.exists());
        CRLRevocationManager.getInstance().removeCrlCacheFile(distURI);
        crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        Assertions.assertFalse((boolean)crlFile.exists());
    }
}

