/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.mail.internet.InternetAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.BaseKeyStoreManagerCertStoreTest;
import org.nhindirect.stagent.utils.TestUtils;

public class CacheableKeyStoreManagerCertificateStore_getCertificatesTest
extends BaseKeyStoreManagerCertStoreTest {
    @Test
    public void testGetCertificate_noCertsInStore_assertNoFound() throws Exception {
        if (this.store != null) {
            Assertions.assertTrue((boolean)this.store.getCertificates("user1").isEmpty());
        }
    }

    @Test
    public void testGetCertificate_existingCertsInStore_assertFound() throws Exception {
        if (this.store != null) {
            X509CertificateEx user1 = TestUtils.getInternalCert("user1");
            this.store.add((X509Certificate)user1);
            Collection retrievedCerts = this.store.getCertificates("user1@cerner.com");
            Assertions.assertEquals((int)1, (int)retrievedCerts.size());
            X509Certificate retrievedCert = (X509Certificate)retrievedCerts.iterator().next();
            Assertions.assertTrue((boolean)(retrievedCert instanceof X509CertificateEx));
            Assertions.assertEquals((Object)user1, (Object)retrievedCert);
        }
    }

    @Test
    public void testGetCertificate_existingCertsInStore_findByEmailAddress_assertFound() throws Exception {
        if (this.store != null) {
            X509CertificateEx user1 = TestUtils.getInternalCert("user1");
            this.store.add((X509Certificate)user1);
            Collection retrievedCerts = this.store.getCertificates(new InternetAddress("user1@cerner.com"));
            Assertions.assertEquals((int)1, (int)retrievedCerts.size());
            X509Certificate retrievedCert = (X509Certificate)retrievedCerts.iterator().next();
            Assertions.assertTrue((boolean)(retrievedCert instanceof X509CertificateEx));
            Assertions.assertEquals((Object)user1, (Object)retrievedCert);
        }
    }
}

