/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.LdapCertUtilImpl;
import org.nhindirect.stagent.utils.BaseTestPlan;

public class LdapCertUtilImpl_ProcessPKCS12FileFormatAndAddToCertificates_Test {
    @Test
    public void testPKCS12File() throws Exception {
        new TestPlan(){

            @Override
            protected void doAssertions() throws Exception {
                Assertions.assertNotNull((Object)this.theCreateCertificates);
                Assertions.assertEquals((int)1, (int)this.theCreateCertificates.size());
                X509Certificate cert = (X509Certificate)this.theCreateCertificates.iterator().next();
                Assertions.assertTrue((boolean)(cert instanceof X509CertificateEx));
                X509CertificateEx privateCert = (X509CertificateEx)cert;
                Assertions.assertNotNull((Object)privateCert.getPrivateKey());
                System.out.println(privateCert.getIssuerDN());
                Assertions.assertEquals((Object)"EMAILADDRESS=gm2552@securehealthemail.com, CN=Greg Meyer, OU=Medical Informatics, O=Cerner, ST=Missouri, C=US", (Object)privateCert.getSubjectDN().toString());
                System.out.println(privateCert.getIssuerX500Principal());
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected ByteArrayInputStream theCreateInputStream;
        protected ArrayList<X509Certificate> theCreateCertificates;
        protected String theCreateKeyStorePassword;
        protected int toCharArrayCalls = 0;
        protected char[] theToCharArray;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            LdapCertUtilImpl impl = this.createLdapCertUtilImpl();
            impl.processPKCS12FileFormatAndAddToCertificates(this.createInputStream(), this.createCertificates());
            this.doAssertions();
        }

        protected LdapCertUtilImpl createLdapCertUtilImpl() throws Exception {
            return new LdapCertUtilImpl(null, this.createKeyStorePassword(), null){};
        }

        protected ByteArrayInputStream createInputStream() throws Exception {
            File fl = new File("testfile");
            int idx = fl.getAbsolutePath().lastIndexOf("testfile");
            String path = fl.getAbsolutePath().substring(0, idx);
            byte[] buffer = new byte[(int)new File(path + "src/test/resources/certs/gm2552encrypted.p12").length() + 100];
            BufferedInputStream f = new BufferedInputStream(new FileInputStream(path + "src/test/resources/certs/gm2552encrypted.p12"));
            f.read(buffer);
            this.theCreateInputStream = new ByteArrayInputStream(buffer);
            IOUtils.closeQuietly((InputStream)f);
            return this.theCreateInputStream;
        }

        protected ArrayList<X509Certificate> createCertificates() throws Exception {
            this.theCreateCertificates = new ArrayList();
            return this.theCreateCertificates;
        }

        protected char[] toCharArray_Internal() {
            this.theToCharArray = new char[0];
            return this.theToCharArray;
        }

        protected String createKeyStorePassword() {
            this.theCreateKeyStorePassword = "1kingpuff";
            return this.theCreateKeyStorePassword;
        }

        protected void doAssertions() throws Exception {
        }
    }
}

