/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsManagerUtils;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.EncryptionAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;

public class SMIMECryptographerImpl_constructTest {
    @BeforeEach
    public void setUp() {
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    @AfterEach
    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerOptions();
    }

    @Test
    public void testContructSMIMECryptographerImpl_defaultSettings() {
        SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
        Assertions.assertEquals((Object)DigestAlgorithm.SHA256WITHRSA, (Object)impl.getDigestAlgorithm());
        Assertions.assertEquals((Object)EncryptionAlgorithm.AES128, (Object)impl.getEncryptionAlgorithm());
    }

    @Test
    public void testContructSMIMECryptographerImpl_setAlgorithms() {
        SMIMECryptographerImpl impl = new SMIMECryptographerImpl(EncryptionAlgorithm.RSA_3DES, DigestAlgorithm.SHA384);
        Assertions.assertEquals((Object)DigestAlgorithm.SHA384, (Object)impl.getDigestAlgorithm());
        Assertions.assertEquals((Object)EncryptionAlgorithm.RSA_3DES, (Object)impl.getEncryptionAlgorithm());
    }

    @Test
    public void testContructSMIMECryptographerImpl_disallowedDigestAlgorithm_assertException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SMIMECryptographerImpl(EncryptionAlgorithm.AES128, DigestAlgorithm.SHA1));
    }

    @Test
    public void testContructSMIMECryptographerImpl_JVMSettings() {
        System.setProperty("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm", "AES256");
        System.setProperty("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm", "SHA256");
        try {
            SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
            Assertions.assertEquals((Object)DigestAlgorithm.SHA256, (Object)impl.getDigestAlgorithm());
            Assertions.assertEquals((Object)EncryptionAlgorithm.AES256, (Object)impl.getEncryptionAlgorithm());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm", "");
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm", "");
        }
    }

    @Test
    public void testContructSMIMECryptographerImpl_invalidDigestOption_assertException() {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("CRYPTOGRAHPER_SMIME_DIGEST_ALGORITHM", DigestAlgorithm.SHA1.getAlgName()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SMIMECryptographerImpl());
    }

    @Test
    public void testContructSMIMECryptographerImpl_InvalidJVMSettings() {
        System.setProperty("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm", "AES256323");
        System.setProperty("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm", "SHA2564323");
        try {
            SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
            Assertions.assertEquals((Object)DigestAlgorithm.SHA256WITHRSA, (Object)impl.getDigestAlgorithm());
            Assertions.assertEquals((Object)EncryptionAlgorithm.AES128, (Object)impl.getEncryptionAlgorithm());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm", "");
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContructSMIMECryptographerImpl_propFileSettings() throws Exception {
        File propFile = new File("./target/props/agentSettings.properties");
        if (propFile.exists()) {
            propFile.delete();
        }
        System.setProperty("org.nhindirect.stagent.PropertiesFile", "./target/props/agentSettings.properties");
        try (FileOutputStream outStream = FileUtils.openOutputStream((File)propFile);){
            ((OutputStream)outStream).write("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm=AES192\r\n".getBytes());
            ((OutputStream)outStream).write("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm=SHA512".getBytes());
            outStream.flush();
        }
        try {
            SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
            Assertions.assertEquals((Object)DigestAlgorithm.SHA512, (Object)impl.getDigestAlgorithm());
            Assertions.assertEquals((Object)EncryptionAlgorithm.AES192, (Object)impl.getEncryptionAlgorithm());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm", "");
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm", "");
            System.setProperty("org.nhindirect.stagent.PropertiesFile", "");
            propFile.delete();
        }
    }
}

