/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.NHINDStandard;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.WrappedMessage;
import org.nhindirect.stagent.utils.TestUtils;

public class WrappedMessageTest {
    @Test
    public void testCopyNHINDStandard_assertPromotedCCHeaders() throws Exception {
        Message msg = new Message();
        String msgId = UUID.randomUUID().toString();
        msg.addHeader("message-id", msgId);
        msg.addHeader("cc", "test@testdomain.com, gm2552@cerner.com");
        msg.addHeader("MIME-Version", "1.0");
        msg.setContent((Object)"SomeText", "text/plain");
        Message wrappedMessage = WrappedMessage.create((Message)msg, (String[])NHINDStandard.MailHeadersUsed);
        String ccHeader = wrappedMessage.getHeader("cc", ",");
        Assertions.assertNotNull((Object)ccHeader);
        Assertions.assertEquals((Object)"test@testdomain.com, gm2552@cerner.com", (Object)ccHeader);
    }

    @Test
    public void testCopyNHINDStandard_fromFullMessage_assertPromotedCCHeaders() throws Exception {
        String testMessage = TestUtils.readResource("CCTestMessage.txt");
        Message msg = new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        Message wrappedMessage = WrappedMessage.create((Message)msg, (String[])NHINDStandard.MailHeadersUsed);
        String ccHeader = wrappedMessage.getHeader("cc", ",");
        Assertions.assertNotNull((Object)ccHeader);
        Assertions.assertEquals((Object)"User1@Cerner.com, gm2552@cerner.com", (Object)ccHeader);
    }

    @Test
    public void testCopyNHINDStandard_encyrptMessage_assertPromotedInvalidCCHeaders() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("cerner.com"));
        String testMessage = TestUtils.readResource("CCTestMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        String ccHeader = SMIMEenvMessage.getMessage().getHeader("cc", ",");
        Assertions.assertNotNull((Object)ccHeader);
        Assertions.assertEquals((Object)"User1@Cerner.com", (Object)ccHeader);
    }
}

