/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import com.sun.mail.dsn.DispositionNotification;
import java.util.ArrayList;
import java.util.Arrays;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import org.apache.james.javax.MimeMultipartReport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.mail.notifications.Disposition;
import org.nhindirect.stagent.mail.notifications.MDNFactory;
import org.nhindirect.stagent.mail.notifications.MdnGateway;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationType;

public class MDNFactory_createTest {
    public static InternetHeaders getNotificationFieldsAsHeaders(MimeMultipart mm) {
        InternetHeaders retVal = null;
        if (mm == null) {
            throw new IllegalArgumentException("Multipart can not be null");
        }
        try {
            String[] fields;
            if (mm.getCount() < 2) {
                throw new IllegalArgumentException("Multipart can not be null");
            }
            BodyPart part = mm.getBodyPart(1);
            if (part.getContent() instanceof DispositionNotification) {
                return ((DispositionNotification)part.getContent()).getNotifications();
            }
            retVal = new InternetHeaders();
            for (String field : fields = Notification.getPartContentBodyAsString((BodyPart)part).split("\r\n")) {
                int idx = field.indexOf(":");
                if (idx <= -1) continue;
                String name = field.substring(0, idx);
                String value = field.substring(idx + 1).trim();
                retVal.setHeader(name, value);
            }
        }
        catch (Exception e) {
            throw new NHINDException("Failed to parse notification fields.", e);
        }
        return retVal;
    }

    @Test
    public void testCreate_withGernalAttributes() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"junit error", (MdnGateway)gateway, (Disposition)disp, (String)"", (String)"", new ArrayList());
        Assertions.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        Assertions.assertTrue((boolean)headers.getHeader("Reporting-UA", ",").startsWith("junitUA"));
        Assertions.assertTrue((boolean)headers.getHeader("Reporting-UA", ",").endsWith("junitProduct"));
        Assertions.assertEquals((Object)"rfc822; sender@send.com", (Object)headers.getHeader("Original-Recipient", ","));
        Assertions.assertEquals((Object)"rfc822; final@final.com", (Object)headers.getHeader("Final-Recipient", ","));
        Assertions.assertTrue((boolean)headers.getHeader("MDN-Gateway", ",").endsWith("junitGateway"));
        Assertions.assertTrue((boolean)headers.getHeader("Disposition", ",").endsWith(NotificationType.Processed.toString()));
        BodyPart part0 = report.getBodyPart(0);
        Object obj = part0.getContent();
        Assertions.assertEquals((Object)"test", (Object)obj);
    }

    @Test
    public void testCreate_withError() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"junit error", (MdnGateway)gateway, (Disposition)disp, (String)"", (String)"", new ArrayList());
        Assertions.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        Assertions.assertEquals((Object)"junit error", (Object)headers.getHeader("Error", ","));
    }

    @Test
    public void testCreate_withError_oldConstructor() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"junit error", (MdnGateway)gateway, (Disposition)disp);
        Assertions.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        Assertions.assertEquals((Object)"junit error", (Object)headers.getHeader("Error", ","));
    }

    @Test
    public void testCreate_withWarning() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"", (MdnGateway)gateway, (Disposition)disp, (String)"junit warning", (String)"", new ArrayList());
        Assertions.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        Assertions.assertEquals((Object)"junit warning", (Object)headers.getHeader("Warning", ","));
    }

    @Test
    public void testCreate_withFailure() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"", (MdnGateway)gateway, (Disposition)disp, (String)"", (String)"junit failure", new ArrayList());
        Assertions.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        Assertions.assertEquals((Object)"junit failure", (Object)headers.getHeader("Failure", ","));
    }

    @Test
    public void testCreate_withExtensionNameOnly() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"", (MdnGateway)gateway, (Disposition)disp, (String)"", (String)"junit failure", Arrays.asList("X-EXTENSION"));
        Assertions.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        Assertions.assertEquals((Object)"", (Object)headers.getHeader("X-EXTENSION", ","));
    }

    @Test
    public void testCreate_withExtensionNameWithValue() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"", (MdnGateway)gateway, (Disposition)disp, (String)"", (String)"junit failure", Arrays.asList("X-EXTENSION:junit value"));
        Assertions.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        Assertions.assertEquals((Object)"junit value", (Object)headers.getHeader("X-EXTENSION", ","));
    }

    @Test
    public void testCreate_noDisposition_assertException() throws Exception {
        MdnGateway gateway = new MdnGateway("junitGateway");
        boolean exceptionOccured = false;
        try {
            MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"", (MdnGateway)gateway, null, (String)"", (String)"junit failure", Arrays.asList("X-EXTENSION:junit value"));
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

