/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.mail.internet.MimeMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.utils.TestUtils;

public class NotificationMessage_createNotificationForTest {
    @Test
    public void testCreateNotificationFor_processedMDN_assertSubjectHasCorrectPrefix() throws Exception {
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        MimeMessage msg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        Notification noti = new Notification(NotificationType.Processed);
        NotificationMessage notiMsg = NotificationMessage.createNotificationFor((Message)new Message(msg), (Notification)noti);
        Assertions.assertTrue((boolean)notiMsg.getHeader("subject", ",").startsWith("Processed"));
    }

    @Test
    public void testCreateNotificationFor_dispatchedMDN_assertSubjectHasCorrectPrefix() throws Exception {
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        MimeMessage msg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        Notification noti = new Notification(NotificationType.Dispatched);
        NotificationMessage notiMsg = NotificationMessage.createNotificationFor((Message)new Message(msg), (Notification)noti);
        Assertions.assertTrue((boolean)notiMsg.getHeader("subject", ",").startsWith("Dispatched"));
    }
}

