/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import com.sun.mail.dsn.DispositionNotification;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.notifications.MdnGateway;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationType;
import org.nhindirect.stagent.mail.notifications.ReportingUserAgent;
import org.nhindirect.stagent.utils.TestUtils;

public class NotificationTest {
    @Test
    public void testCreateNotification_AssertMultipart() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(0);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("text/plain"));
        Assertions.assertEquals((Object)"Your message was successfully processed.", (Object)part.getContent().toString());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        part.writeTo((OutputStream)outStream);
        String content = new String(outStream.toByteArray());
        Assertions.assertTrue((boolean)content.contains("automatic-action/MDN-sent-automatically;processed"));
    }

    @Test
    public void testCreateNotification_AssertGetParts() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        ArrayList entities = (ArrayList)noti.getParts();
        MimeEntity entity = (MimeEntity)entities.get(0);
        Assertions.assertEquals((Object)"Your message was successfully processed.", (Object)entity.getContent().toString());
        entity = (MimeEntity)entities.get(1);
        Assertions.assertTrue((boolean)entity.getContentType().startsWith("message/disposition-notification"));
        DispositionNotification notification = (DispositionNotification)entity.getContent();
        Assertions.assertEquals((Object)notification.getNotifications().getHeader("disposition", ","), (Object)"automatic-action/MDN-sent-automatically;processed");
    }

    @Test
    public void testCreateNotification_AssertDispatched() throws Exception {
        Notification noti = new Notification(NotificationType.Dispatched);
        ArrayList entities = (ArrayList)noti.getParts();
        MimeEntity entity = (MimeEntity)entities.get(0);
        Assertions.assertEquals((Object)"Your message was successfully processed.", (Object)entity.getContent().toString());
        entity = (MimeEntity)entities.get(1);
        Assertions.assertTrue((boolean)entity.getContentType().startsWith("message/disposition-notification"));
        DispositionNotification notification = (DispositionNotification)entity.getContent();
        Assertions.assertEquals((Object)notification.getNotifications().getHeader("disposition", ","), (Object)"automatic-action/MDN-sent-automatically;dispatched");
    }

    @Test
    public void testCreateNotification_AssertInputStream() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        ByteArrayDataSource dataSource = new ByteArrayDataSource(noti.getInputStream(), noti.getAsMultipart().getContentType());
        MimeMultipart mm = new MimeMultipart((DataSource)dataSource);
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(0);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("text/plain"));
        Assertions.assertEquals((Object)"Your message was successfully processed.", (Object)part.getContent().toString());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        DispositionNotification notification = (DispositionNotification)part.getContent();
        Assertions.assertEquals((Object)notification.getNotifications().getHeader("disposition", ","), (Object)"automatic-action/MDN-sent-automatically;processed");
    }

    @Test
    public void testSetExplanation_AssertExplanation() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(0);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("text/plain"));
        Assertions.assertEquals((Object)"Your message was successfully processed.", (Object)part.getContent().toString());
        noti.setExplanation("Testing this explantation");
        mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(0);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("text/plain"));
        Assertions.assertEquals((Object)"Testing this explantation", (Object)noti.getExplanation());
        Assertions.assertEquals((Object)noti.getExplanation(), (Object)part.getContent().toString());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        part.writeTo((OutputStream)outStream);
        String content = new String(outStream.toByteArray());
        Assertions.assertTrue((boolean)content.contains("automatic-action/MDN-sent-automatically;processed"));
    }

    @Test
    public void testSetUserAgent_AssertUseragent() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNull((Object)headers.getHeader("Reporting-UA"));
        noti.setReportingAgent(new ReportingUserAgent("Junit Agent Name", "Junit Product Name"));
        mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNotNull((Object)headers.getHeader("Reporting-UA"));
        Assertions.assertEquals((Object)"Junit Agent Name; Junit Product Name", (Object)headers.getHeader("Reporting-UA", ","));
        Assertions.assertEquals((Object)headers.getHeader("Reporting-UA", ","), (Object)noti.getReportingAgent().toString());
    }

    @Test
    public void testGateway_AssertGateway() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNull((Object)headers.getHeader("MDN-Gateway"));
        noti.setGateway(new MdnGateway("Junit domain", "Junit type"));
        mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNotNull((Object)headers.getHeader("MDN-Gateway"));
        Assertions.assertEquals((Object)"Junit type; Junit domain", (Object)headers.getHeader("MDN-Gateway", ","));
        Assertions.assertEquals((Object)headers.getHeader("MDN-Gateway", ","), (Object)noti.getGateway().toString());
    }

    @Test
    public void testOriginalMessageId_AssertOriginalMessageId() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNull((Object)headers.getHeader("Original-Message-ID"));
        noti.setOriginalMessageId("Orig Msg Id");
        mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNotNull((Object)headers.getHeader("Original-Message-ID"));
        Assertions.assertEquals((Object)"Orig Msg Id", (Object)headers.getHeader("Original-Message-ID", ","));
        Assertions.assertEquals((Object)headers.getHeader("Original-Message-ID", ","), (Object)noti.getOriginalMessageId());
    }

    @Test
    public void testFinalRecip_AssertFinalRecip() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNull((Object)headers.getHeader("Final-Recipient"));
        noti.setFinalRecipient("Test Final Recip");
        mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNotNull((Object)headers.getHeader("Final-Recipient"));
        Assertions.assertEquals((Object)"rfc822; Test Final Recip", (Object)headers.getHeader("Final-Recipient", ","));
        Assertions.assertEquals((Object)headers.getHeader("Final-Recipient", ","), (Object)("rfc822; " + noti.getFinalRecipeint()));
    }

    @Test
    public void testError_AssertError() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNull((Object)headers.getHeader("Error"));
        noti.setError("Junit Error");
        mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNotNull((Object)headers.getHeader("Error"));
        Assertions.assertEquals((Object)"Junit Error", (Object)headers.getHeader("Error", ","));
        Assertions.assertEquals((Object)headers.getHeader("Error", ","), (Object)noti.getError());
    }

    @Test
    public void testParseFieldsFromMimeMessage() throws Exception {
        String testMessage = TestUtils.readResource("MDNMessage.txt");
        MimeMessage msg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        InternetHeaders headers = Notification.getNotificationFieldsAsHeaders((MimeMessage)msg);
        Assertions.assertNotNull((Object)headers.getHeader("Disposition"));
        Assertions.assertEquals((Object)"automatic-action/MDN-sent-automatically;processed", (Object)headers.getHeader("Disposition", ","));
        Assertions.assertNotNull((Object)headers.getHeader("Reporting-UA"));
        Assertions.assertEquals((Object)"starugh-stateline.com;NHIN Direct Security Agent", (Object)headers.getHeader("Reporting-UA", ","));
        Assertions.assertNotNull((Object)headers.getHeader("Final-Recipient"));
        Assertions.assertEquals((Object)"externUser1@starugh-stateline.com", (Object)headers.getHeader("Final-Recipient", ","));
        Assertions.assertNotNull((Object)headers.getHeader("Original-Message-ID"));
        Assertions.assertEquals((Object)"<9501051053.aa04167@IETF.CNR I.Reston.VA.US>", (Object)headers.getHeader("Original-Message-ID", ","));
    }

    @Test
    public void testParseFieldsFromMimeMessage_NonMDNMessage_AssertExecption() throws Exception {
        String testMessage = TestUtils.readResource("MessageWithAttachment.txt");
        MimeMessage msg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        boolean exceptionOccured = false;
        try {
            Notification.getNotificationFieldsAsHeaders((MimeMessage)msg);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testWarning_AssertWarning() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNull((Object)headers.getHeader("Final-Recipient"));
        noti.setWarning("junit warning");
        mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNotNull((Object)headers.getHeader("Warning"));
        Assertions.assertEquals((Object)"junit warning", (Object)headers.getHeader("Warning", ","));
    }

    @Test
    public void testFailure_AssertFailure() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNull((Object)headers.getHeader("Final-Recipient"));
        noti.setFailure("junit failure");
        mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNotNull((Object)headers.getHeader("Failure"));
        Assertions.assertEquals((Object)"junit failure", (Object)headers.getHeader("Failure", ","));
    }

    @Test
    public void testExtensions_AssertExtensions() throws Exception {
        Notification noti = new Notification(NotificationType.Processed);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        InternetHeaders headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNull((Object)headers.getHeader("Final-Recipient"));
        noti.setExtensions(Arrays.asList("X-TEST1", "X-TEST2:value"));
        mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        headers = noti.getNotificationFieldsAsHeaders();
        Assertions.assertNotNull((Object)headers.getHeader("X-TEST1"));
        Assertions.assertEquals((Object)"", (Object)headers.getHeader("X-TEST1", ","));
        Assertions.assertNotNull((Object)headers.getHeader("X-TEST2"));
        Assertions.assertEquals((Object)"value", (Object)headers.getHeader("X-TEST2", ","));
    }

    @Test
    public void testFailedNotification() throws Exception {
        Notification noti = new Notification(NotificationType.Failed);
        System.out.println(noti);
        MimeMultipart mm = noti.getAsMultipart();
        Assertions.assertNotNull((Object)mm);
        Assertions.assertEquals((int)2, (int)mm.getCount());
        BodyPart part = mm.getBodyPart(0);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("text/plain"));
        Assertions.assertEquals((Object)"Your message encountered an error and failed delivery to the target system. Please contact your administrator.", (Object)part.getContent().toString());
        part = mm.getBodyPart(1);
        Assertions.assertTrue((boolean)part.getContentType().startsWith("message/disposition-notification"));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        part.writeTo((OutputStream)outStream);
        String content = new String(outStream.toByteArray());
        Assertions.assertTrue((boolean)content.contains("automatic-action/MDN-sent-automatically;failed"));
    }
}

