/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.policy.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.stagent.policy.impl.DomainPolicyResolver;

public class DomainPolicyResolver_contstuctTest {
    @Test
    public void testConstruct_sameForIncomingAndOutgoing_assertAttributes() {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        List<PolicyExpression> expressions = Arrays.asList(expression);
        HashMap<String, List<PolicyExpression>> policies = new HashMap<String, List<PolicyExpression>>();
        policies.put("testdomain.com", expressions);
        DomainPolicyResolver resolver = new DomainPolicyResolver(policies);
        Assertions.assertNotNull((Object)resolver);
        Assertions.assertEquals((int)1, (int)resolver.incomingPolicies.size());
        Collection retrievedExpressions = (Collection)resolver.incomingPolicies.get("TESTDOMAIN.COM");
        Assertions.assertNotNull((Object)retrievedExpressions);
        Assertions.assertEquals((int)1, (int)resolver.outgoingPolicies.size());
        retrievedExpressions = (Collection)resolver.outgoingPolicies.get("TESTDOMAIN.COM");
        Assertions.assertNotNull((Object)retrievedExpressions);
    }

    @Test
    public void testConstruct_differentForIncomingAndOutgoing_assertAttributes() {
        PolicyExpression expression1 = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        List<PolicyExpression> expressions1 = Arrays.asList(expression1);
        HashMap<String, List<PolicyExpression>> outgoingPolicies = new HashMap<String, List<PolicyExpression>>();
        outgoingPolicies.put("testdomain.com", expressions1);
        PolicyExpression expression2 = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        PolicyExpression expression3 = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        List<PolicyExpression> expressions2 = Arrays.asList(expression2, expression3);
        HashMap<String, List<PolicyExpression>> incomingPolicies = new HashMap<String, List<PolicyExpression>>();
        incomingPolicies.put("testdomain.com", expressions2);
        DomainPolicyResolver resolver = new DomainPolicyResolver(incomingPolicies, outgoingPolicies);
        Assertions.assertNotNull((Object)resolver);
        Assertions.assertEquals((int)1, (int)resolver.outgoingPolicies.size());
        Collection retrievedExpressions = (Collection)resolver.outgoingPolicies.get("TESTDOMAIN.COM");
        Assertions.assertEquals((int)1, (int)retrievedExpressions.size());
        Assertions.assertNotNull((Object)retrievedExpressions);
        Assertions.assertEquals((int)1, (int)resolver.incomingPolicies.size());
        retrievedExpressions = (Collection)resolver.incomingPolicies.get("TESTDOMAIN.COM");
        Assertions.assertEquals((int)2, (int)retrievedExpressions.size());
        Assertions.assertNotNull((Object)retrievedExpressions);
    }

    @Test
    public void testConstruct_nullPolicies_assertException() {
        boolean exceptionOccured = false;
        try {
            new DomainPolicyResolver(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            new DomainPolicyResolver(null, null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

