/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.policy.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.stagent.policy.impl.DomainPolicyResolver;

public class DomainPolicyResolver_getPolicyTest {
    @Test
    public void testGetPolicy_incomingPolicyExists_assertPolicies() throws Exception {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        List<PolicyExpression> expressions = Arrays.asList(expression);
        HashMap<String, List<PolicyExpression>> policies = new HashMap<String, List<PolicyExpression>>();
        policies.put("testdomain.com", expressions);
        DomainPolicyResolver resolver = new DomainPolicyResolver(policies);
        Collection retrievedExpressions = resolver.getIncomingPolicy(new InternetAddress("me@testdomain.com"));
        Assertions.assertNotNull((Object)retrievedExpressions);
        Assertions.assertEquals((int)1, (int)retrievedExpressions.size());
    }

    @Test
    public void testGetPolicy_incomingPolicyDoesNotExist_assertEmpty() throws Exception {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        List<PolicyExpression> expressions = Arrays.asList(expression);
        HashMap<String, List<PolicyExpression>> policies = new HashMap<String, List<PolicyExpression>>();
        policies.put("testdomain.com", expressions);
        DomainPolicyResolver resolver = new DomainPolicyResolver(policies);
        Collection retrievedExpressions = resolver.getIncomingPolicy(new InternetAddress("me@testdomainother.com"));
        Assertions.assertNotNull((Object)retrievedExpressions);
        Assertions.assertEquals((int)0, (int)retrievedExpressions.size());
    }

    @Test
    public void testGetPolicy_outgoingPolicyExists_assertPolicies() throws Exception {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        List<PolicyExpression> expressions = Arrays.asList(expression);
        HashMap<String, List<PolicyExpression>> policies = new HashMap<String, List<PolicyExpression>>();
        policies.put("testdomain.com", expressions);
        DomainPolicyResolver resolver = new DomainPolicyResolver(policies);
        Collection retrievedExpressions = resolver.getOutgoingPolicy(new InternetAddress("me@testdomain.com"));
        Assertions.assertNotNull((Object)retrievedExpressions);
        Assertions.assertEquals((int)1, (int)retrievedExpressions.size());
    }

    @Test
    public void testGetPolicy_outgoingPolicyDoesNotExist_assertEmpty() throws Exception {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        List<PolicyExpression> expressions = Arrays.asList(expression);
        HashMap<String, List<PolicyExpression>> policies = new HashMap<String, List<PolicyExpression>>();
        policies.put("testdomain.com", expressions);
        DomainPolicyResolver resolver = new DomainPolicyResolver(policies);
        Collection retrievedExpressions = resolver.getOutgoingPolicy(new InternetAddress("me@testdomainother.com"));
        Assertions.assertNotNull((Object)retrievedExpressions);
        Assertions.assertEquals((int)0, (int)retrievedExpressions.size());
    }

    @Test
    public void testGetPolicy_nullAddress_assertException() throws Exception {
        ArrayList expressions = new ArrayList();
        HashMap policies = new HashMap();
        policies.put("testdomain.com", expressions);
        DomainPolicyResolver resolver = new DomainPolicyResolver(policies);
        boolean exceptionOccured = false;
        try {
            resolver.getIncomingPolicy(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

