/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.mail.internet.InternetAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyFilter;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.policy.PolicyResolver;
import org.nhindirect.stagent.trust.TrustModel;

public class TrustModel_isCertPolicyCompliantTest {
    @Test
    public void testIsCertPolicyCompliant_noResolver_assertTrue() throws Exception {
        TrustModel model = new TrustModel();
        model.setTrustPolicyResolver(null);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Assertions.assertTrue((boolean)model.isCertPolicyCompliant(new InternetAddress("me@test.com"), cert));
    }

    @Test
    public void testIsCertPolicyCompliant_noPolicyFilter_assertTrue() throws Exception {
        TrustModel model = new TrustModel();
        model.setTrustPolicyResolver((PolicyResolver)Mockito.mock(PolicyResolver.class));
        model.setPolicyFilter(null);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Assertions.assertTrue((boolean)model.isCertPolicyCompliant(new InternetAddress("me@test.com"), cert));
    }

    @Test
    public void testIsCertPolicyCompliant_noPolicyExpression_assertTrue() throws Exception {
        TrustModel model = new TrustModel();
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        Mockito.when((Object)resolver.getIncomingPolicy((InternetAddress)ArgumentMatchers.any())).thenReturn(new ArrayList());
        model.setTrustPolicyResolver(resolver);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Assertions.assertTrue((boolean)model.isCertPolicyCompliant(new InternetAddress("me@test.com"), cert));
    }

    @Test
    public void testIsCertPolicyCompliant_policyCompliant_assertTrue() throws Exception {
        TrustModel model = new TrustModel();
        PolicyFilter filter = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        Mockito.when((Object)filter.isCompliant((X509Certificate)ArgumentMatchers.any(), (PolicyExpression)ArgumentMatchers.any())).thenReturn((Object)true);
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        Mockito.when((Object)resolver.getIncomingPolicy((InternetAddress)ArgumentMatchers.any())).thenReturn(Arrays.asList(expression));
        model.setTrustPolicyResolver(resolver);
        model.setPolicyFilter(filter);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Assertions.assertTrue((boolean)model.isCertPolicyCompliant(new InternetAddress("me@test.com"), cert));
    }

    @Test
    public void testIsCertPolicyCompliant_policyNotCompliant_assertFalse() throws Exception {
        TrustModel model = new TrustModel();
        PolicyFilter filter = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        Mockito.when((Object)filter.isCompliant((X509Certificate)ArgumentMatchers.any(), (PolicyExpression)ArgumentMatchers.any())).thenReturn((Object)false);
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        Mockito.when((Object)resolver.getIncomingPolicy((InternetAddress)ArgumentMatchers.any())).thenReturn(Arrays.asList(expression));
        model.setTrustPolicyResolver(resolver);
        model.setPolicyFilter(filter);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Assertions.assertFalse((boolean)model.isCertPolicyCompliant(new InternetAddress("me@test.com"), cert));
    }

    @Test
    public void testIsCertPolicyCompliant_missingRequiredField_assertFalse() throws Exception {
        TrustModel model = new TrustModel();
        PolicyFilter filter = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        ((PolicyFilter)Mockito.doThrow((Throwable[])new Throwable[]{new PolicyRequiredException("Just Passing Through")}).when((Object)filter)).isCompliant((X509Certificate)ArgumentMatchers.any(), (PolicyExpression)ArgumentMatchers.any());
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        Mockito.when((Object)resolver.getIncomingPolicy((InternetAddress)ArgumentMatchers.any())).thenReturn(Arrays.asList(expression));
        model.setTrustPolicyResolver(resolver);
        model.setPolicyFilter(filter);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Assertions.assertFalse((boolean)model.isCertPolicyCompliant(new InternetAddress("me@test.com"), cert));
    }

    @Test
    public void testIsCertPolicyCompliant_policyExpressionError_assertExecption() throws Exception {
        TrustModel model = new TrustModel();
        PolicyFilter filter = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        ((PolicyFilter)Mockito.doThrow((Throwable[])new Throwable[]{new PolicyProcessException("Just Passing Through")}).when((Object)filter)).isCompliant((X509Certificate)ArgumentMatchers.any(), (PolicyExpression)ArgumentMatchers.any());
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        Mockito.when((Object)resolver.getIncomingPolicy((InternetAddress)ArgumentMatchers.any())).thenReturn(Arrays.asList(expression));
        model.setTrustPolicyResolver(resolver);
        model.setPolicyFilter(filter);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        boolean exceptionOccured = false;
        try {
            model.isCertPolicyCompliant(new InternetAddress("me@test.com"), cert);
        }
        catch (AgentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

